/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v113_2;

import net.minecraft.server.v1_13_R2.DataPaletteBlock;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.dynmap.DynmapCore;
import org.dynmap.bukkit.helper.AbstractMapChunkCache;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.v113_2.BukkitVersionHelperSpigot113_2;
import org.dynmap.renderer.DynmapBlockState;

public class MapChunkCache113_2
extends AbstractMapChunkCache {
    public AbstractMapChunkCache.Snapshot wrapChunkSnapshot(ChunkSnapshot css) {
        return new WrappedSnapshot(css);
    }

    public boolean loadChunkNoGenerate(World w, int x, int z) {
        boolean rslt = w.loadChunk(x, z, false);
        if (!rslt && DynmapCore.migrateChunks()) {
            boolean generated = true;
            block0: for (int xx = x - 3; xx <= x + 3; ++xx) {
                for (int zz = z - 3; zz <= z + 3; ++zz) {
                    if (w.isChunkGenerated(xx, zz)) continue;
                    generated = false;
                    continue block0;
                }
            }
            if (generated) {
                rslt = w.loadChunk(x, z, true);
            }
        }
        return rslt;
    }

    public static class WrappedSnapshot
    implements AbstractMapChunkCache.Snapshot {
        private final ChunkSnapshot ss;
        private final DataPaletteBlock[] blockids;
        private final int sectionmask;

        public WrappedSnapshot(ChunkSnapshot ss) {
            this.ss = ss;
            this.blockids = (DataPaletteBlock[])BukkitVersionHelper.helper.getBlockIDFieldFromSnapshot(ss);
            int mask = 0;
            for (int i = 0; i < this.blockids.length; ++i) {
                if (!ss.isSectionEmpty(i)) continue;
                mask |= 1 << i;
            }
            this.sectionmask = mask;
        }

        public final DynmapBlockState getBlockType(int x, int y, int z) {
            if ((this.sectionmask & 1 << (y >> 4)) != 0) {
                return DynmapBlockState.AIR;
            }
            return BukkitVersionHelperSpigot113_2.dataToState.getOrDefault(this.blockids[y >> 4].a(x & 0xF, y & 0xF, z & 0xF), DynmapBlockState.AIR);
        }

        public final int getBlockSkyLight(int x, int y, int z) {
            return this.ss.getBlockSkyLight(x, y, z);
        }

        public final int getBlockEmittedLight(int x, int y, int z) {
            return this.ss.getBlockEmittedLight(x, y, z);
        }

        public final int getHighestBlockYAt(int x, int z) {
            return this.ss.getHighestBlockYAt(x, z);
        }

        public final Biome getBiome(int x, int z) {
            return this.ss.getBiome(x, z);
        }

        public final boolean isSectionEmpty(int sy) {
            return (this.sectionmask & 1 << sy) != 0;
        }

        public final Object[] getBiomeBaseFromSnapshot() {
            return BukkitVersionHelper.helper.getBiomeBaseFromSnapshot(this.ss);
        }
    }
}

