/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.actions.ActionProviders;
import top.mrxiaom.pluginbase.api.IAction;
import top.mrxiaom.pluginbase.utils.AdventureUtil;
import top.mrxiaom.pluginbase.utils.PAPI;
import top.mrxiaom.pluginbase.utils.Pair;
import top.mrxiaom.pluginbase.utils.SkullsUtil;

public class Util {
    public static Map<String, OfflinePlayer> players = new TreeMap<String, OfflinePlayer>(String.CASE_INSENSITIVE_ORDER);
    public static Map<UUID, OfflinePlayer> playersByUUID = new TreeMap<UUID, OfflinePlayer>();

    public static void init(BukkitPlugin plugin) {
        plugin.getScheduler().runTaskAsync(() -> {
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (player.getName() == null) continue;
                players.put(player.getName(), player);
                playersByUUID.put(player.getUniqueId(), player);
            }
        });
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(PlayerJoinEvent e) {
                Player player = e.getPlayer();
                players.put(player.getName(), (OfflinePlayer)player);
                playersByUUID.put(player.getUniqueId(), (OfflinePlayer)player);
            }
        }, (Plugin)plugin);
        try {
            PAPI.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            SkullsUtil.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (plugin.options.adventure()) {
            AdventureUtil.init(plugin);
        }
    }

    public static void reloadFolder(File folder, boolean suffix, BiConsumer<String, File> reloadConfig) {
        Util.reloadFolder(folder, null, suffix, reloadConfig);
    }

    private static void reloadFolder(File root, File folder, boolean suffix, BiConsumer<String, File> reloadConfig) {
        File[] files = (folder == null ? root : folder).listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (new File(file, ".ignore").exists()) continue;
                    Util.reloadFolder(root, file, suffix, reloadConfig);
                    continue;
                }
                String id = Util.getRelationPath(root, file, suffix);
                reloadConfig.accept(id, file);
            }
        }
    }

    public static String getRelationPath(File parent, File file, boolean suffix) {
        String parentPath = parent.getAbsolutePath();
        String path = file.getAbsolutePath();
        if (!path.startsWith(parentPath)) {
            return suffix ? path : Util.nameWithoutSuffix(path);
        }
        String s = path.substring(parentPath.length()).replace("\\", "/");
        String relation = s.startsWith("/") ? s.substring(1) : s;
        return suffix ? relation : Util.nameWithoutSuffix(relation);
    }

    public static String nameWithoutSuffix(String s) {
        int index = s.lastIndexOf(46);
        return index <= 0 ? s : s.substring(0, index);
    }

    @NotNull
    public static List<ConfigurationSection> getSectionList(ConfigurationSection parent, String key) {
        ArrayList<ConfigurationSection> list = new ArrayList<ConfigurationSection>();
        List rawList = parent.getMapList(key);
        for (Map map : rawList) {
            MemoryConfiguration section = new MemoryConfiguration();
            for (Map.Entry entry : map.entrySet()) {
                String sectionKey = entry.getKey().toString();
                section.set(sectionKey, Util.processValue((ConfigurationSection)section, sectionKey, entry.getValue()));
            }
            list.add((ConfigurationSection)section);
        }
        return list;
    }

    private static Object processValue(ConfigurationSection parent, String key, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            Object section = parent == null || key == null ? new MemoryConfiguration() : parent.createSection(key);
            for (Map.Entry entry : map.entrySet()) {
                String mapKey = entry.getKey().toString();
                section.set(mapKey, Util.processValue((ConfigurationSection)section, mapKey, entry.getValue()));
            }
            return section;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : list) {
                result.add(Util.processValue(null, null, object));
            }
            return result;
        }
        return value;
    }

    public static Double getPercentAsDouble(ConfigurationSection section, String key, Double def) {
        return Util.getPercentAsDouble(section.getString(key, null), def);
    }

    public static Float getPercentAsFloat(ConfigurationSection section, String key, Float def) {
        return Util.getPercentAsFloat(section.getString(key, null), def);
    }

    public static Double getPercentAsDouble(String s, Double def) {
        if (s == null) {
            return def;
        }
        try {
            if (s.endsWith("%")) {
                String str = s.substring(0, s.length() - 1);
                double value = Double.parseDouble(str);
                return value / 100.0;
            }
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Float getPercentAsFloat(String s, Float def) {
        if (s == null) {
            return def;
        }
        try {
            if (s.endsWith("%")) {
                String str = s.substring(0, s.length() - 1);
                float value = Float.parseFloat(str);
                return Float.valueOf(value / 100.0f);
            }
            return Float.valueOf(Float.parseFloat(s));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static Double getDouble(ConfigurationSection section, String key, Double def) {
        return section.contains(key) && section.isDouble(key) ? Double.valueOf(section.getDouble(key)) : def;
    }

    public static Integer getInt(ConfigurationSection section, String key, Integer def) {
        return section.contains(key) && section.isInt(key) ? Integer.valueOf(section.getInt(key)) : def;
    }

    public static Material getItem(ConfigurationSection section, String key, Material def) {
        if (section == null) {
            return def;
        }
        return Util.valueOr(Material.class, section.getString(key), def);
    }

    public static List<String> split(String string, String spliter) {
        return Util.split(string, spliter, 0);
    }

    public static List<String> split(String string, String spliter, int limit) {
        int i;
        int oldIndex = 0;
        int length = spliter.length();
        if (length == 0) {
            throw new IllegalArgumentException("spliter can't be empty!");
        }
        int count = limit - 1;
        boolean unlimited = limit <= 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((unlimited || list.size() < count) && (i = string.indexOf(spliter, oldIndex)) >= 0) {
            if (oldIndex == i) {
                list.add("");
            } else {
                list.add(string.substring(oldIndex, i));
            }
            oldIndex = i + length;
        }
        list.add(string.substring(oldIndex));
        return list;
    }

    public static List<String> split(String string, char spliter) {
        return Util.split(string, spliter, 0);
    }

    public static List<String> split(String string, char spliter, int limit) {
        int i;
        int oldIndex = 0;
        int count = limit - 1;
        boolean unlimited = limit <= 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((unlimited || list.size() < count) && (i = string.indexOf(spliter, oldIndex)) >= 0) {
            if (oldIndex == i) {
                list.add("");
            } else {
                list.add(string.substring(oldIndex, i));
            }
            oldIndex = i + 1;
        }
        list.add(string.substring(oldIndex));
        return list;
    }

    public static boolean createNewFile(File file) throws IOException {
        return file.createNewFile();
    }

    public static boolean mkdirs(File file) {
        return file.mkdirs();
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    public static void submitInvUpdate(Player player) {
        player.updateInventory();
    }

    @Deprecated
    @SafeVarargs
    public static void runCommands(Player player, List<String> list, Pair<String, Object> ... replacements) {
        List<IAction> actions = ActionProviders.loadActions(list);
        ArrayList args = Lists.newArrayList((Object[])replacements);
        for (IAction action : actions) {
            action.run(player, args);
        }
    }

    public static List<String> startsWith(String s, String ... texts) {
        return Util.startsWith(s, Lists.newArrayList((Object[])texts));
    }

    public static List<String> startsWith(String s, Iterable<String> texts) {
        ArrayList<String> list = new ArrayList<String>();
        s = s.toLowerCase();
        for (String text : texts) {
            if (!text.toLowerCase().startsWith(s)) continue;
            list.add(text);
        }
        return list;
    }

    public static Location toLocation(String world, String loc) {
        Location l = null;
        try {
            String[] s = loc.split(",");
            double x = Double.parseDouble(s[0]);
            double y = Double.parseDouble(s[1]);
            double z = Double.parseDouble(s[2]);
            float yaw = s.length > 3 ? Float.parseFloat(s[3]) : 0.0f;
            float pitch = s.length > 4 ? Float.parseFloat(s[4]) : 0.0f;
            l = new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public static String fromLocation(Location loc) {
        return String.format("%.2f,%.2f,%.2f,%.2f,%.2f", loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()));
    }

    public static boolean isMovedLoc(PlayerMoveEvent e) {
        return Util.isMovedLoc(e.getFrom(), e.getTo());
    }

    public static boolean isMovedLoc(Location loc1, Location loc2) {
        return loc1 != null && loc2 != null && (loc1.getX() != loc2.getX() || loc1.getZ() != loc2.getZ());
    }

    public static Optional<OfflinePlayer> getOfflinePlayer(String name) {
        return Optional.ofNullable(players.get(name));
    }

    public static Optional<OfflinePlayer> getOfflinePlayer(UUID uuid) {
        return Optional.ofNullable(playersByUUID.get(uuid));
    }

    public static Optional<Player> getOnlinePlayer(String name) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static Optional<Player> getOnlinePlayer(UUID uuid) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getUniqueId().equals(uuid)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static List<Player> getOnlinePlayersByUUID(Collection<UUID> uuidList) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!uuidList.contains(player.getUniqueId())) continue;
            players.add(player);
        }
        return players;
    }

    public static List<Player> getOnlinePlayersByName(Collection<String> nameList) {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        names.addAll(nameList);
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!names.contains(player.getName())) continue;
            players.add(player);
        }
        return players;
    }

    public static Optional<Float> parseFloat(String s) {
        if (s == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Float.valueOf(Float.parseFloat(s)));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Double> parseDouble(String s) {
        if (s == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Integer> parseInt(String s) {
        if (s == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Long> parseLong(String s) {
        if (s == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static <T extends Enum<?>> T valueOr(Class<T> c, String s, T def) {
        if (s == null) {
            return def;
        }
        for (Enum t : (Enum[])c.getEnumConstants()) {
            if (!t.name().equalsIgnoreCase(s)) continue;
            return (T)t;
        }
        return def;
    }

    public static <T> List<List<T>> chunk(List<T> list, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> temp = new ArrayList<T>();
        for (T item : list) {
            temp.add(item);
            if (temp.size() != size) continue;
            result.add(temp);
            temp = new ArrayList();
        }
        if (!temp.isEmpty()) {
            result.add(temp);
        }
        return result;
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static void split(Pattern regex, String s, Consumer<RegexResult> consumer) {
        int index = 0;
        Matcher m = regex.matcher(s);
        while (m.find()) {
            int first = m.start();
            int last = m.end();
            if (first > index) {
                consumer.accept(new RegexResult(null, s.substring(index, first)));
            }
            consumer.accept(new RegexResult(m.toMatchResult(), s.substring(first, last)));
            index = last;
        }
        if (index < s.length()) {
            consumer.accept(new RegexResult(null, s.substring(index)));
        }
    }

    public static <T> List<T> split(Pattern regex, String s, Function<RegexResult, T> transform) {
        T value;
        ArrayList<T> list = new ArrayList<T>();
        int index = 0;
        Matcher m = regex.matcher(s);
        while (m.find()) {
            T value2;
            int first = m.start();
            int last = m.end();
            if (first > index && (value2 = transform.apply(new RegexResult(null, s.substring(index, first)))) != null) {
                list.add(value2);
            }
            if ((value2 = transform.apply(new RegexResult(m.toMatchResult(), s.substring(first, last)))) != null) {
                list.add(value2);
            }
            index = last;
        }
        if (index < s.length() && (value = transform.apply(new RegexResult(null, s.substring(index)))) != null) {
            list.add(value);
        }
        return list;
    }

    public static double between(double num, double min, double max) {
        if (num < min) {
            num = min;
        }
        if (num > max) {
            num = max;
        }
        return num;
    }

    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName, List<String> ignorePackages) {
        TreeSet classes = new TreeSet(Comparator.comparing(Class::getName));
        try {
            String name = packageName.replace(".", "/");
            Enumeration<URL> urls = loader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    Util.findAnnotatedClassesInDirectory(new File(url.toURI()), packageName, ignorePackages, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                Util.findAnnotatedClassesInJar(url, packageName, ignorePackages, classes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classes;
    }

    private static void findAnnotatedClassesInDirectory(File directory, String packageName, List<String> ignorePackages, Set<Class<?>> classes) {
        File[] files = directory.listFiles(file -> file.isFile() && file.getName().endsWith(".class") || file.isDirectory());
        if (files != null) {
            for (File file2 : files) {
                if (file2.isFile()) {
                    String className = packageName + '.' + file2.getName().substring(0, file2.getName().length() - 6);
                    for (String ignorePackage : ignorePackages) {
                        if (!className.startsWith(ignorePackage)) continue;
                        return;
                    }
                    try {
                        classes.add(Class.forName(className));
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
                    continue;
                }
                if (!file2.isDirectory()) continue;
                Util.findAnnotatedClassesInDirectory(file2, packageName + "." + file2.getName(), ignorePackages, classes);
            }
        }
    }

    private static void findAnnotatedClassesInJar(URL url, String packageName, List<String> ignorePackages, Set<Class<?>> classes) throws Exception {
        String packagePath = packageName.replace(".", "/");
        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packagePath) || !name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - 6).replace("/", ".");
            boolean flag = false;
            for (String ignorePackage : ignorePackages) {
                if (!className.startsWith(ignorePackage)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
        }
    }

    public static class RegexResult {
        public final MatchResult result;
        public final boolean isMatched;
        public final String text;

        public RegexResult(MatchResult result, String text) {
            this.result = result;
            this.isMatched = result != null;
            this.text = text;
        }
    }
}

