/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.tr7zw.changeme.nbtapi.utils.MinecraftVersion;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;

public class SkullsUtil {
    private static final Map<String, Skull> cached = new HashMap<String, Skull>();
    private static final Gson GSON = new Gson();
    private static boolean HAS_PLAYER_PROFILES;
    private static ItemStack headItem;

    protected static void init() {
        HAS_PLAYER_PROFILES = MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_18_R1);
        headItem = MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_13_R1) ? new ItemStack(Material.PLAYER_HEAD, 1) : new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
    }

    public static ItemStack createHeadItem() {
        return headItem.clone();
    }

    public static ItemMeta setSkullBase64(ItemMeta meta, String base64) {
        if (meta instanceof SkullMeta) {
            Skull skull = cached.get(base64);
            if (skull == null) {
                skull = SkullsUtil.generateSkull(base64);
                if (skull != null) {
                    cached.put(base64, skull);
                } else {
                    return meta;
                }
            }
            skull.setSkull((SkullMeta)meta);
        }
        return meta;
    }

    @Nullable
    public static Skull generateSkull(@NotNull String base64) {
        if (base64.isEmpty()) {
            return null;
        }
        if (HAS_PLAYER_PROFILES) {
            PlayerProfile profile = SkullsUtil.getPlayerProfile(base64);
            return new Skull(meta -> meta.setOwnerProfile(profile));
        }
        GameProfile profile = SkullsUtil.getGameProfile(base64);
        return new Skull(meta -> {
            try {
                Field field = meta.getClass().getDeclaredField("profile");
                field.setAccessible(true);
                field.set(meta, profile);
            }
            catch (ReflectiveOperationException e) {
                BukkitPlugin.getInstance().warn("\u65e0\u6cd5\u4ece base64 \u52a0\u8f7d\u5934\u9885\u6750\u8d28", e);
            }
        });
    }

    @NotNull
    private static GameProfile getGameProfile(@NotNull String base64) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64));
        return profile;
    }

    @NotNull
    private static PlayerProfile getPlayerProfile(@NotNull String base64) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        String decodedBase64 = SkullsUtil.decodeSkinUrl(base64);
        if (decodedBase64 == null) {
            return profile;
        }
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(decodedBase64));
        }
        catch (MalformedURLException e) {
            BukkitPlugin.getInstance().warn("\u5c1d\u8bd5\u521b\u5efa base64 \u5934\u9885\u6750\u8d28\u94fe\u63a5\u65f6\u51fa\u73b0\u95ee\u9898", e);
        }
        profile.setTextures(textures);
        return profile;
    }

    @Nullable
    private static String decodeSkinUrl(@NotNull String base64) {
        String decoded = new String(Base64.getDecoder().decode(base64));
        JsonObject object = (JsonObject)GSON.fromJson(decoded, JsonObject.class);
        JsonElement textures = object.get("textures");
        if (textures == null || !textures.isJsonObject()) {
            return null;
        }
        JsonElement skin = textures.getAsJsonObject().get("SKIN");
        if (skin == null || !skin.isJsonObject()) {
            return null;
        }
        JsonElement url = skin.getAsJsonObject().get("url");
        return url == null ? null : url.getAsString();
    }

    public static class Skull {
        private final Consumer<SkullMeta> applier;

        public Skull(Consumer<SkullMeta> applier) {
            this.applier = applier;
        }

        public void setSkull(SkullMeta meta) {
            this.applier.accept(meta);
        }
    }
}

