/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Pair<K, V> {
    K key;
    V value;

    private Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public K key() {
        return this.key;
    }

    public K left() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void key(K key) {
        this.key = key;
    }

    public void left(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public V value() {
        return this.value;
    }

    public V right() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public void value(V value) {
        this.value = value;
    }

    public void right(V value) {
        this.value = value;
    }

    public <S, T> Pair<S, T> cast() {
        return this;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public static List<String> replace(List<String> list, @Nullable Iterable<Pair<String, Object>> replacements) {
        if (replacements == null) {
            return new ArrayList<String>(list);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(Pair.replace(s, replacements));
        }
        return result;
    }

    public static List<String> replace(List<String> list, Pair<String, Object> @Nullable [] replacements) {
        if (replacements == null) {
            return new ArrayList<String>(list);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(Pair.replace(s, replacements));
        }
        return result;
    }

    public static String replace(String s, @Nullable Iterable<Pair<String, Object>> replacements) {
        if (replacements == null) {
            return s;
        }
        for (Pair<String, Object> replacement : replacements) {
            if (((String)replacement.key).startsWith("__internal__")) continue;
            s = s.replace((CharSequence)replacement.key, String.valueOf(replacement.value));
        }
        return s;
    }

    public static String replace(String s, Pair<String, Object> @Nullable [] replacements) {
        if (replacements == null) {
            return s;
        }
        for (Pair<String, Object> replacement : replacements) {
            if (((String)replacement.key).startsWith("__internal__")) continue;
            s = s.replace((CharSequence)replacement.key, String.valueOf(replacement.value));
        }
        return s;
    }

    @Nullable
    public static <K, V> V firstOrNull(Pair<K, V>[] array, K key) {
        for (Pair<K, V> pair : array) {
            if (!(key == null ? pair.key == null : key.equals(pair.key))) continue;
            return pair.value;
        }
        return null;
    }

    public static <K, V> Pair<K, V>[] array(int length) {
        return new Pair[length];
    }
}

