/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AbstractPluginHolder;
import top.mrxiaom.pluginbase.utils.ColorHelper;
import top.mrxiaom.pluginbase.utils.IA;
import top.mrxiaom.pluginbase.utils.Pair;
import top.mrxiaom.pluginbase.utils.SkullsUtil;
import top.mrxiaom.pluginbase.utils.Util;

public class ItemStackUtil {
    private static final Integer[] frameSlots54 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final Integer[] frameSlots45 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final Integer[] frameSlots36 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35};
    private static final Integer[] frameSlots27 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final String[] materialColors = new String[]{"STAINED_GLASS", "STAINED_GLASS_PANE", "WOOL", "CARPET"};
    private static final String[] dataValueColors = new String[]{"WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK"};
    private static final String[] dataValueSkulls = new String[]{"SKELETON_SKULL", "WITHER_SKELETON_SKULL", "ZOMBIE_HEAD", "PLAYER_HEAD", "CREEPER_HEAD", "SKELETON_WALL_SKULL", "WITHER_SKELETON_WALL_SKULL", "ZOMBIE_WALL_HEAD", "PLAYER_WALL_HEAD", "CREEPER_WALL_HEAD"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serializeItem(ItemStack item) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            try (BukkitObjectOutputStream out = new BukkitObjectOutputStream((OutputStream)bytes);){
                out.writeObject((Object)item);
            }
            String string = Base64Coder.encodeLines((byte[])bytes.toByteArray());
            return string;
        }
        catch (Throwable t) {
            BukkitPlugin.getInstance().warn("\u5e8f\u5217\u5316\u7269\u54c1\u65f6\u51fa\u73b0\u4e00\u4e2a\u9519\u8bef", t);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serializeItems(ItemStack[] items) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            try (BukkitObjectOutputStream out = new BukkitObjectOutputStream((OutputStream)bytes);){
                out.writeInt(items.length);
                for (ItemStack item : items) {
                    out.writeObject((Object)item);
                }
            }
            String string = Base64Coder.encodeLines((byte[])bytes.toByteArray());
            return string;
        }
        catch (Throwable t) {
            BukkitPlugin.getInstance().warn("\u5e8f\u5217\u5316\u7269\u54c1\u65f6\u51fa\u73b0\u4e00\u4e2a\u9519\u8bef", t);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static ItemStack deserializeItem(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static ItemStack[] deserializeItems(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getItemDisplayName(ItemStack item) {
        if (item == null || !item.hasItemMeta() || item.getItemMeta() == null) {
            return item != null ? item.getType().name() : "";
        }
        return item.getItemMeta().getDisplayName();
    }

    public static List<String> getItemLore(ItemStack item) {
        if (item == null || !item.hasItemMeta() || item.getItemMeta() == null || item.getItemMeta().getLore() == null) {
            return new ArrayList<String>();
        }
        return item.getItemMeta().getLore();
    }

    public static void reduceItemInMainHand(Player player) {
        ItemStackUtil.reduceItemInMainHand(player, 1);
    }

    public static void reduceItemInMainHand(Player player, int amount) {
        ItemStack im = player.getInventory().getItemInMainHand();
        if (im.getAmount() - amount > 0) {
            im.setAmount(im.getAmount() - amount);
            player.getInventory().setItemInMainHand(im);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
    }

    public static void reduceItemInOffHand(Player player) {
        ItemStackUtil.reduceItemInOffHand(player, 1);
    }

    public static void reduceItemInOffHand(Player player, int amount) {
        ItemStack im = player.getInventory().getItemInOffHand();
        if (im.getAmount() - amount > 0) {
            im.setAmount(im.getAmount() - amount);
            player.getInventory().setItemInOffHand(im);
        } else {
            player.getInventory().setItemInOffHand(null);
        }
    }

    public static void setItemDisplayName(ItemStack item, String name) {
        ItemMeta im;
        if (item == null) {
            return;
        }
        ItemMeta itemMeta = im = item.getItemMeta() == null ? ItemStackUtil.getItemMeta(item.getType()) : item.getItemMeta();
        if (im == null) {
            return;
        }
        im.setDisplayName(ColorHelper.parseColor(name));
        item.setItemMeta(im);
    }

    public static void setItemLore(ItemStack item, String ... lore) {
        ItemStackUtil.setItemLore(item, Lists.newArrayList((Object[])lore));
    }

    public static void setItemLore(ItemStack item, List<String> lore) {
        ItemMeta im;
        if (item == null) {
            return;
        }
        ItemMeta itemMeta = im = item.getItemMeta() == null ? ItemStackUtil.getItemMeta(item.getType()) : item.getItemMeta();
        if (im == null) {
            return;
        }
        ArrayList newLore = new ArrayList();
        lore.forEach(s -> {
            if (s != null) {
                newLore.add(ColorHelper.parseColor(s));
            }
        });
        im.setLore(newLore);
        item.setItemMeta(im);
    }

    public static void setCustomModelData(ItemStack item, Integer customModelData) {
        try {
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setCustomModelData(customModelData);
                item.setItemMeta(meta);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ItemStack buildFrameItem(Material material) {
        if (material.equals((Object)Material.AIR)) {
            return new ItemStack(material);
        }
        return ItemStackUtil.buildItem(material, "&f&l*", Lists.newArrayList());
    }

    public static ItemStack buildItem(Material material, String name) {
        if (material.equals((Object)Material.AIR)) {
            return new ItemStack(material);
        }
        return ItemStackUtil.buildItem(material, null, name, Lists.newArrayList());
    }

    public static ItemStack buildItem(Material material, String name, String ... lore) {
        if (material.equals((Object)Material.AIR)) {
            return new ItemStack(material);
        }
        return ItemStackUtil.buildItem(material, null, name, Lists.newArrayList((Object[])lore));
    }

    public static ItemStack buildItem(Material material, Integer customModeData, String name, String ... lore) {
        if (material.equals((Object)Material.AIR)) {
            return new ItemStack(material);
        }
        return ItemStackUtil.buildItem(material, customModeData, name, Lists.newArrayList((Object[])lore));
    }

    public static ItemStack buildItem(Material material, String name, List<String> lore) {
        return ItemStackUtil.buildItem(material, null, name, lore);
    }

    public static ItemStack buildItem(Material material, Integer customModelData, String name, List<String> lore) {
        if (material.equals((Object)Material.AIR)) {
            return new ItemStack(material);
        }
        ItemStack item = new ItemStack(material, 1);
        ItemMeta im = ItemStackUtil.getItemMeta(material);
        im.setDisplayName(ColorHelper.parseColor(name));
        if (!lore.isEmpty()) {
            im.setLore(ColorHelper.parseColor(lore));
        }
        if (customModelData != null) {
            im.setCustomModelData(customModelData);
        }
        item.setItemMeta(im);
        return item;
    }

    public static void setGlow(ItemStack item) {
        ItemMeta meta = ItemStackUtil.getItemMeta(item);
        meta.addEnchant(Enchantment.DURABILITY, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
    }

    @NotNull
    public static ItemStack getItem(String str) {
        return ItemStackUtil.getItem(str, false);
    }

    @Nullable
    public static ItemStack getItem(String str, boolean defNull) {
        Pair<Material, Integer> pair;
        if (str.startsWith("itemsadder-")) {
            Optional<ItemStack> item = IA.get(str.substring(11));
            if (defNull && !item.isPresent()) {
                return null;
            }
            return item.orElseThrow(() -> new IllegalStateException("\u627e\u4e0d\u5230 IA \u7269\u54c1 " + str.substring(11)));
        }
        if (str.startsWith("head-base64-")) {
            ItemStack item = SkullsUtil.createHeadItem();
            String base64 = str.substring(12);
            ItemMeta meta = SkullsUtil.setSkullBase64(item.getItemMeta(), base64);
            if (meta != null) {
                item.setItemMeta(meta);
            }
            return item;
        }
        Integer customModelData = null;
        String material = str;
        if (str.contains("#")) {
            String customModel = str.substring(str.indexOf("#") + 1);
            customModelData = Util.parseInt(customModel).orElse(null);
            material = str.replace("#" + customModelData, "");
        }
        if ((pair = ItemStackUtil.parseMaterial(material)) == null) {
            if (defNull) {
                return null;
            }
            throw new IllegalStateException("\u627e\u4e0d\u5230\u7269\u54c1 " + material);
        }
        ItemStack item = ItemStackUtil.legacy(pair);
        if (customModelData != null) {
            try {
                ItemMeta meta = ItemStackUtil.getItemMeta(item);
                meta.setCustomModelData(customModelData);
                item.setItemMeta(meta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return item;
    }

    @Nullable
    public static Pair<Material, Integer> parseMaterial(String input) {
        Integer dataValue;
        String str;
        if (input.contains(":")) {
            String[] split = input.split(":", 2);
            str = split[0];
            dataValue = Util.parseInt(split[1]).orElse(null);
        } else {
            str = input;
            dataValue = null;
        }
        Material material = ItemStackUtil.parseOrNull(str);
        if (dataValue != null) {
            if (material == null) {
                return null;
            }
            return Pair.of(material, dataValue);
        }
        if (material != null) {
            return Pair.of(material, null);
        }
        if (str.endsWith("_CONCRETE") || str.endsWith("_TERRACOTTA")) {
            material = ItemStackUtil.parseOrNull("STAINED_HARDENED_CLAY");
        } else if (str.contains("BANNER") && !str.contains("PATTERN")) {
            material = ItemStackUtil.parseOrNull("BANNER");
        } else if (str.endsWith("DYE")) {
            material = ItemStackUtil.parseOrNull("INK_SACK");
        } else {
            for (String mc : materialColors) {
                if (!str.endsWith(mc)) continue;
                material = ItemStackUtil.parseOrNull(mc);
                break;
            }
        }
        if (material != null) {
            Integer data = null;
            boolean reverse = str.endsWith("DYE");
            for (int i = 0; i < dataValueColors.length; ++i) {
                if (!str.startsWith(dataValueColors[i])) continue;
                data = reverse ? 15 - i : i;
                break;
            }
            return Pair.of(material, data);
        }
        int skullData = 3;
        for (int i = 0; i < dataValueSkulls.length; ++i) {
            if (!str.equals(dataValueSkulls[i])) continue;
            material = ItemStackUtil.parseOrNull("SKULL_ITEM");
            skullData = i % 5;
            break;
        }
        if (material != null) {
            return Pair.of(material, skullData);
        }
        Integer data = null;
        if (str.contains("_HEAD") && (material = ItemStackUtil.parseOrNull("SKULL_ITEM")) != null) {
            data = 3;
        }
        if (material == null && str.equals("CLOCK")) {
            material = ItemStackUtil.parseOrNull("WATCH");
        }
        if (material == null && str.contains("BED")) {
            material = ItemStackUtil.parseOrNull("BED");
        }
        if (material == null && str.equals("CRAFT_TABLE")) {
            material = ItemStackUtil.parseOrNull("WORKBENCH");
        }
        if (material == null && str.contains("_DOOR") && !str.contains("IRON")) {
            material = ItemStackUtil.parseOrNull("WOODEN_DOOR");
        }
        if (material == null && str.startsWith("WOODEN_")) {
            material = ItemStackUtil.parseOrNull(str.replace("WOODEN_", "WOOD_"));
        }
        if (material == null && str.equals("IRON_BARS")) {
            material = ItemStackUtil.parseOrNull("IRON_FENCE");
        }
        if (material == null && str.equals("BUNDLE")) {
            material = ItemStackUtil.parseOrNull("FEATHER");
        }
        if (material == null && str.equals("ENDER_EYE")) {
            material = ItemStackUtil.parseOrNull("EYE_OF_ENDER");
        }
        if (material == null && str.equals("COMMAND_BLOCK")) {
            material = ItemStackUtil.parseOrNull("COMMAND");
        }
        if (material == null && str.equals("COMMAND_BLOCK_MINECART")) {
            material = ItemStackUtil.parseOrNull("COMMAND_MINECART");
        }
        if (material == null && str.equals("CHAIN_COMMAND_BLOCK")) {
            material = ItemStackUtil.parseOrNull("COMMAND_CHAIN");
        }
        if (material == null && str.equals("REPEATING_COMMAND_BLOCK")) {
            material = ItemStackUtil.parseOrNull("COMMAND_REPEATING");
        }
        if (material != null) {
            return Pair.of(material, data);
        }
        return null;
    }

    @Nullable
    public static Material parseOrNull(String str) {
        return Util.valueOr(Material.class, str, null);
    }

    public static ItemStack legacy(Pair<Material, Integer> pair) {
        Material material = pair.getKey();
        Integer dataValue = pair.getValue();
        if (dataValue != null) {
            return new ItemStack(material, 1, dataValue.shortValue());
        }
        return new ItemStack(material);
    }

    @NotNull
    public static ItemMeta getItemMeta(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta == null ? ItemStackUtil.getItemMeta(item.getType()) : meta;
    }

    public static ItemMeta getItemMeta(Material material) {
        return Bukkit.getItemFactory().getItemMeta(material);
    }

    public static void setFrameItems(Inventory inv, ItemStack item) {
        Integer[] frameSlots;
        switch (inv.getSize()) {
            case 27: {
                frameSlots = frameSlots27;
                break;
            }
            case 36: {
                frameSlots = frameSlots36;
                break;
            }
            case 45: {
                frameSlots = frameSlots45;
                break;
            }
            case 54: {
                frameSlots = frameSlots54;
                break;
            }
            default: {
                return;
            }
        }
        Integer[] integerArray = frameSlots;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int slot = integerArray[i];
            inv.setItem(slot, item);
        }
    }

    public static void setRowItems(Inventory inv, int row, ItemStack item) {
        for (int i = 0; i < 9; ++i) {
            inv.setItem((row - 1) * 9 + i, item);
        }
    }

    public static ItemStack getEnchantedBook(Enchantment enchantment, int level) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(enchantment, level);
        return ItemStackUtil.getEnchantedBook(map);
    }

    public static ItemStack getEnchantedBook(Map<Enchantment, Integer> map) {
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta im = item.getItemMeta();
        if (im == null) {
            return item;
        }
        for (Enchantment enchantment : map.keySet()) {
            ((EnchantmentStorageMeta)im).addStoredEnchant(enchantment, map.get(enchantment).intValue(), true);
        }
        item.setItemMeta(im);
        return item;
    }

    public static void giveItemToPlayer(Player player, List<ItemStack> items) {
        ItemStackUtil.giveItemToPlayer(player, items.toArray(new ItemStack[0]));
    }

    public static void giveItemToPlayer(Player player, ItemStack ... items) {
        ItemStackUtil.giveItemToPlayer(player, "", "", items);
    }

    public static void giveItemToPlayer(Player player, String msg, String msgFull, List<ItemStack> items) {
        ItemStackUtil.giveItemToPlayer(player, msg, msgFull, items.toArray(new ItemStack[0]));
    }

    public static void giveItemToPlayer(Player player, String msg, String msgFull, ItemStack ... items) {
        Collection last = player.getInventory().addItem(items).values();
        if (!msg.isEmpty() || !last.isEmpty() && !msgFull.isEmpty()) {
            AbstractPluginHolder.t((CommandSender)player, msg + (last.isEmpty() ? "" : "\n&r" + msgFull));
        }
        for (ItemStack item : last) {
            player.getWorld().dropItem(player.getLocation(), item);
        }
    }
}

