/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AbstractPluginHolder;

public class ConfigUpdater
extends AbstractPluginHolder<BukkitPlugin> {
    public static final boolean supportComments = ConfigUpdater.checkSupportComments();
    public static final Function<String, Boolean> ALL_MATCHER = s -> true;
    private final YamlConfiguration defaultConfig;
    private final List<String> autoSaveFullMatch = new ArrayList<String>();
    private final List<String> autoSavePrefixMatch = new ArrayList<String>();
    private final List<Function<String, Boolean>> autoSaveCustomMatch = new ArrayList<Function<String, Boolean>>();

    private static boolean checkSupportComments() {
        try {
            MemorySection.class.getDeclaredMethod("getComments", String.class);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private ConfigUpdater(BukkitPlugin plugin, YamlConfiguration defaultConfig) {
        super(plugin);
        this.defaultConfig = defaultConfig;
    }

    private static boolean notEquals(List<String> list1, List<String> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }

    public ConfigUpdater fullMatch(String s) {
        this.autoSaveFullMatch.add(s);
        return this;
    }

    public ConfigUpdater prefixMatch(String s) {
        this.autoSavePrefixMatch.add(s);
        return this;
    }

    public ConfigUpdater customMatch(Function<String, Boolean> func) {
        this.autoSaveCustomMatch.add(func);
        return this;
    }

    public boolean isKeyMatch(String key) {
        for (String string : this.autoSaveFullMatch) {
            if (!key.equals(string)) continue;
            return true;
        }
        for (String string : this.autoSavePrefixMatch) {
            if (!key.startsWith(string)) continue;
            return true;
        }
        for (Function function : this.autoSaveCustomMatch) {
            if (!((Boolean)function.apply(key)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public ConfigUpdater apply(@NotNull YamlConfiguration config, @Nullable File saveFile) {
        boolean modified = false;
        for (String key : this.defaultConfig.getKeys(true)) {
            List defInlineComments;
            List inlineComments;
            List defComments;
            if (this.defaultConfig.get(key, null) == null) continue;
            if (config.get(key, null) == null) {
                if (!this.isKeyMatch(key)) continue;
                config.set(key, this.defaultConfig.get(key));
                if (supportComments) {
                    config.setComments(key, this.defaultConfig.getComments(key));
                    config.setInlineComments(key, this.defaultConfig.getInlineComments(key));
                }
                modified = true;
                continue;
            }
            if (!supportComments) continue;
            List comments = config.getComments(key);
            if (ConfigUpdater.notEquals(comments, defComments = this.defaultConfig.getComments(key))) {
                config.setComments(key, defComments);
                modified = true;
            }
            if (!ConfigUpdater.notEquals(inlineComments = config.getInlineComments(key), defInlineComments = this.defaultConfig.getInlineComments(key))) continue;
            config.setInlineComments(key, defInlineComments);
            modified = true;
        }
        if (modified && saveFile != null) {
            try {
                config.save(saveFile);
            }
            catch (IOException e) {
                this.warn(e);
            }
        }
        return this;
    }

    @NotNull
    public static ConfigUpdater create(BukkitPlugin plugin, String resourcePath) {
        return ConfigUpdater.create(plugin, resourcePath, '.');
    }

    @NotNull
    public static ConfigUpdater create(BukkitPlugin plugin, String resourcePath, char pathSeparator) {
        YamlConfiguration defaultConfig = new YamlConfiguration();
        defaultConfig.options().pathSeparator(pathSeparator);
        InputStream resource = plugin.getResource(resourcePath);
        if (resource != null) {
            try (InputStream input = resource;
                 InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
                defaultConfig.load((Reader)reader);
            }
            catch (Exception e) {
                plugin.warn("\u65e0\u6cd5\u8bfb\u53d6\u9ed8\u8ba4\u914d\u7f6e " + resourcePath, e);
            }
        } else {
            plugin.warn("\u9ed8\u8ba4\u914d\u7f6e\u4e0d\u5b58\u5728 " + resourcePath);
        }
        return ConfigUpdater.create(plugin, defaultConfig);
    }

    @NotNull
    public static ConfigUpdater create(BukkitPlugin plugin, YamlConfiguration defaultConfig) {
        return new ConfigUpdater(plugin, defaultConfig);
    }
}

