/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.utils.AdventureUtil;
import top.mrxiaom.pluginbase.utils.Util;

public class ColorHelper {
    private static final Pattern startWithColor = Pattern.compile("^(&[LMNKOlmnko])+");
    private static final Pattern gradientPattern = Pattern.compile("\\{(#[ABCDEFabcdef0123456789]{6}):(#[ABCDEFabcdef0123456789]{6}):(.*?)}");
    private static final Pattern hexPattern = Pattern.compile("&(#[ABCDEFabcdef0123456789]{6})");
    private static final Pattern translatePattern = Pattern.compile("<translate:(.*?)>");
    private static boolean old = false;

    public static void parseAndSend(CommandSender sender, String s) {
        if (BukkitPlugin.getInstance().options.adventure()) {
            AdventureUtil.sendMessage(sender, s);
            return;
        }
        if (old && !(sender instanceof Player)) {
            sender.sendMessage(ColorHelper.parseColor(s));
            return;
        }
        TextComponent builder = new TextComponent("");
        Util.split(translatePattern, ColorHelper.parseColor(s), regexResult -> {
            if (!regexResult.isMatched) {
                builder.addExtra((BaseComponent)new TextComponent(regexResult.text));
            } else {
                TranslatableComponent translatable = new TranslatableComponent(regexResult.result.group(1), new Object[0]);
                builder.addExtra((BaseComponent)translatable);
            }
        });
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.spigot().sendMessage((BaseComponent)builder);
            return;
        }
        try {
            sender.spigot().sendMessage((BaseComponent)builder);
        }
        catch (NoSuchMethodError ignored) {
            old = true;
            sender.sendMessage(ColorHelper.parseColor(s));
        }
    }

    public static List<String> parseColor(List<String> s) {
        return Lists.newArrayList((Object[])ColorHelper.parseColor(String.join((CharSequence)"\n", s)).split("\n"));
    }

    public static String parseColor(String s) {
        String fin = ColorHelper.parseHexText(s);
        fin = ColorHelper.parseGradientText(fin);
        return fin.replace("&", "\u00a7");
    }

    public static String parseHexText(String s) {
        return String.join((CharSequence)"", Util.split(hexPattern, s, regexResult -> {
            if (!regexResult.isMatched) {
                return regexResult.text;
            }
            String hex = regexResult.text.substring(1);
            return ColorHelper.parseHex(hex);
        }));
    }

    public static String parseGradientText(String s) {
        return String.join((CharSequence)"", Util.split(gradientPattern, s, regexResult -> {
            if (!regexResult.isMatched) {
                return regexResult.text;
            }
            String[] args = regexResult.text.substring(1, regexResult.text.length() - 1).split(":", 3);
            String extra = "";
            Matcher m = startWithColor.matcher(args[2]);
            if (m.find()) {
                extra = ChatColor.translateAlternateColorCodes((char)'&', (String)m.group());
            }
            return ColorHelper.parseGradient(m.replaceAll(""), extra, args[0], args[1]);
        }));
    }

    public static String parseGradient(String s, String extraFormat, String startHex, String endHex) {
        s = s.replaceAll("[&\u00a7].", "");
        int color1 = ColorHelper.hex(startHex);
        int color2 = ColorHelper.hex(endHex);
        int[] colors = ColorHelper.createGradient(color1, color2, s.length());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < colors.length; ++i) {
            result.append(ColorHelper.hexToMc(colors[i])).append(extraFormat).append(s.charAt(i));
        }
        return result.toString();
    }

    public static String parseHex(String hex) {
        StringBuilder result = new StringBuilder("\u00a7x");
        for (char c : hex.substring(1, hex.length() - 1).toLowerCase().toCharArray()) {
            result.append('\u00a7').append(c);
        }
        result.append("\u00a7F");
        return result.toString();
    }

    public static int[] createGradient(int startHex, int endHex, int step) {
        if (step == 1) {
            return new int[]{startHex};
        }
        int[] colors = new int[step];
        int[] start = ColorHelper.hexToRGB(startHex);
        int[] end = ColorHelper.hexToRGB(endHex);
        int stepR = (end[0] - start[0]) / (step - 1);
        int stepG = (end[1] - start[1]) / (step - 1);
        int stepB = (end[2] - start[2]) / (step - 1);
        for (int i = 0; i < step; ++i) {
            colors[i] = ColorHelper.rgbToHex(start[0] + stepR * i, start[1] + stepG * i, start[2] + stepB * i);
        }
        return colors;
    }

    public static String hexToMc(int hex) {
        return ColorHelper.parseHex(ColorHelper.hex(hex));
    }

    public static int hex(String hex) {
        return Integer.parseInt(hex.substring(1), 16);
    }

    public static String hex(int hex) {
        return "#" + String.format("%06x", hex);
    }

    public static int[] hexToRGB(int hex) {
        return new int[]{hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex & 0xFF};
    }

    public static int rgbToHex(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }
}

