/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import sun.misc.Unsafe;

public class ClassLoaderWrapper {
    private final URLClassLoader classLoader;
    private final DelegateAddURL addURL;

    public ClassLoaderWrapper(URLClassLoader classLoader) {
        this.classLoader = classLoader;
        this.addURL = this.defineAddURLMethod();
    }

    private DelegateAddURL defineAddURLMethod() {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            return url -> method.invoke((Object)this.classLoader, url);
        }
        catch (Exception method) {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                Unsafe unsafe = (Unsafe)unsafeField.get(null);
                Field fieldUCP = URLClassLoader.class.getDeclaredField("ucp");
                Object ucp = unsafe.getObject(this.classLoader, unsafe.objectFieldOffset(fieldUCP));
                Class<?> clazz = ucp.getClass();
                Field fieldUrls = ClassLoaderWrapper.defineUrlsField(clazz);
                Field fieldPath = clazz.getDeclaredField("path");
                if (fieldUrls != null) {
                    Collection urls = (Collection)unsafe.getObject(ucp, unsafe.objectFieldOffset(fieldUrls));
                    Collection path = (Collection)unsafe.getObject(ucp, unsafe.objectFieldOffset(fieldPath));
                    return url -> {
                        Collection collection = urls;
                        synchronized (collection) {
                            urls.add(url);
                            path.add(url);
                        }
                    };
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return url -> {
                throw new UnsupportedOperationException("\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301 addURL");
            };
        }
    }

    private static Field defineUrlsField(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals("unopenedUrls")) continue;
            return field;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals("urls")) continue;
            return field;
        }
        return null;
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addURL(URL url) throws Exception {
        this.addURL.run(url);
    }

    @FunctionalInterface
    public static interface DelegateAddURL {
        public void run(URL var1) throws Exception;
    }
}

