/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.utils.AdventureItemStack;

public class AdventureUtil {
    private static BukkitAudiences adventure;
    private static MiniMessage miniMessage;

    protected static void init(BukkitPlugin plugin) {
        adventure = (BukkitAudiences)BukkitAudiences.builder((Plugin)plugin).build();
        miniMessage = MiniMessage.builder().postProcessor(it -> it.decoration(TextDecoration.ITALIC, false)).build();
        try {
            AdventureItemStack.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static BukkitAudiences adventure() {
        return adventure;
    }

    public static Audience of(Player player) {
        return adventure.player(player);
    }

    public static Audience of(UUID player) {
        return adventure.player(player);
    }

    public static Audience console() {
        return adventure.sender((CommandSender)Bukkit.getConsoleSender());
    }

    public static MiniMessage miniMessage() {
        return miniMessage;
    }

    @NotNull
    public static Component miniMessage(String s) {
        return s == null ? Component.empty() : miniMessage.deserialize((Object)AdventureUtil.legacyToMiniMessage(s));
    }

    @NotNull
    public static String miniMessage(Component component) {
        return component == null ? "" : (String)miniMessage.serialize(component);
    }

    @NotNull
    public static List<Component> miniMessage(List<String> list) {
        if (list == null) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (String s : list) {
            components.add((Component)(s == null ? Component.empty() : miniMessage.deserialize((Object)AdventureUtil.legacyToMiniMessage(s))));
        }
        return components;
    }

    @NotNull
    public static List<String> miniMessage_(List<Component> components) {
        if (components == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Component component : components) {
            list.add(component == null ? "" : (String)miniMessage.serialize(component));
        }
        return list;
    }

    public static void sendTitle(Player player, String title, String subTitle, int fadeIn, int stay, int fadeOut) {
        adventure.player(player).showTitle(Title.title((Component)AdventureUtil.miniMessage(title), (Component)AdventureUtil.miniMessage(subTitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)fadeIn * 50L), (Duration)Duration.ofMillis((long)stay * 50L), (Duration)Duration.ofMillis((long)fadeOut * 50L))));
    }

    public static void resetTitle(Player player) {
        adventure.player(player).resetTitle();
    }

    public static void clearTitle(Player player) {
        adventure.player(player).clearTitle();
    }

    public static void sendMessage(CommandSender sender, String message) {
        adventure.sender(sender).sendMessage(AdventureUtil.miniMessage(message));
    }

    public static void sendActionBar(Player player, String actionBar) {
        adventure.player(player).sendActionBar(AdventureUtil.miniMessage(actionBar));
    }

    public static String legacyToMiniMessage(String legacy) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = legacy.toCharArray();
        block25: for (int i = 0; i < chars.length; ++i) {
            if (!AdventureUtil.isColorCode(chars[i])) {
                stringBuilder.append(chars[i]);
                continue;
            }
            if (i + 1 >= chars.length) {
                stringBuilder.append(chars[i]);
                continue;
            }
            switch (chars[i + 1]) {
                case '0': {
                    stringBuilder.append("<black>");
                    break;
                }
                case '1': {
                    stringBuilder.append("<dark_blue>");
                    break;
                }
                case '2': {
                    stringBuilder.append("<dark_green>");
                    break;
                }
                case '3': {
                    stringBuilder.append("<dark_aqua>");
                    break;
                }
                case '4': {
                    stringBuilder.append("<dark_red>");
                    break;
                }
                case '5': {
                    stringBuilder.append("<dark_purple>");
                    break;
                }
                case '6': {
                    stringBuilder.append("<gold>");
                    break;
                }
                case '7': {
                    stringBuilder.append("<gray>");
                    break;
                }
                case '8': {
                    stringBuilder.append("<dark_gray>");
                    break;
                }
                case '9': {
                    stringBuilder.append("<blue>");
                    break;
                }
                case 'a': {
                    stringBuilder.append("<green>");
                    break;
                }
                case 'b': {
                    stringBuilder.append("<aqua>");
                    break;
                }
                case 'c': {
                    stringBuilder.append("<red>");
                    break;
                }
                case 'd': {
                    stringBuilder.append("<light_purple>");
                    break;
                }
                case 'e': {
                    stringBuilder.append("<yellow>");
                    break;
                }
                case 'f': {
                    stringBuilder.append("<white>");
                    break;
                }
                case 'r': {
                    stringBuilder.append("<reset><!i>");
                    break;
                }
                case 'l': {
                    stringBuilder.append("<b>");
                    break;
                }
                case 'm': {
                    stringBuilder.append("<st>");
                    break;
                }
                case 'o': {
                    stringBuilder.append("<i>");
                    break;
                }
                case 'n': {
                    stringBuilder.append("<u>");
                    break;
                }
                case 'k': {
                    stringBuilder.append("<obf>");
                    break;
                }
                case 'x': {
                    if (!(i + 13 < chars.length && AdventureUtil.isColorCode(chars[i + 2]) && AdventureUtil.isColorCode(chars[i + 4]) && AdventureUtil.isColorCode(chars[i + 6]) && AdventureUtil.isColorCode(chars[i + 8]) && AdventureUtil.isColorCode(chars[i + 10]) && AdventureUtil.isColorCode(chars[i + 12]))) {
                        stringBuilder.append(chars[i]);
                        continue block25;
                    }
                    stringBuilder.append("<#").append(chars[i + 3]).append(chars[i + 5]).append(chars[i + 7]).append(chars[i + 9]).append(chars[i + 11]).append(chars[i + 13]).append(">");
                    i += 12;
                    break;
                }
                default: {
                    stringBuilder.append(chars[i]);
                    continue block25;
                }
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public static boolean isColorCode(char c) {
        return c == '\u00a7' || c == '&';
    }
}

