/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.utils;

import com.google.common.collect.Lists;
import de.tr7zw.changeme.nbtapi.NBT;
import de.tr7zw.changeme.nbtapi.NBTType;
import de.tr7zw.changeme.nbtapi.handler.NBTHandlers;
import de.tr7zw.changeme.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.changeme.nbtapi.iface.ReadWriteNBTCompoundList;
import de.tr7zw.changeme.nbtapi.iface.ReadWriteNBTList;
import de.tr7zw.changeme.nbtapi.iface.ReadableNBT;
import de.tr7zw.changeme.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.utils.AdventureUtil;

public class AdventureItemStack {
    private static boolean textUseComponent;
    private static boolean itemNbtUseComponentsFormat;
    private static boolean componentUseNBT;

    protected static void init() {
        itemNbtUseComponentsFormat = MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_20_R4);
        ItemStack item = new ItemStack(Material.STONE);
        ItemMeta meta = item.getItemMeta();
        String testDisplayName = "\u00a7a\u00a7l\u6d4b\u8bd5\u00a7e\u00a7l\u6587\u672c";
        if (meta == null) {
            textUseComponent = false;
            componentUseNBT = false;
        } else {
            meta.setDisplayName(testDisplayName);
            item.setItemMeta(meta);
            if (itemNbtUseComponentsFormat) {
                textUseComponent = true;
                componentUseNBT = (Boolean)NBT.getComponents((ItemStack)item, nbt -> {
                    NBTType type = nbt.getType("minecraft:custom_name");
                    return !type.equals((Object)NBTType.NBTTagString);
                });
            } else {
                NBT.get((ItemStack)item, nbt -> {
                    ReadableNBT display = nbt.getCompound("display");
                    if (display == null) {
                        textUseComponent = false;
                        return;
                    }
                    String name = display.getString("Name");
                    textUseComponent = !name.equals(testDisplayName);
                });
                componentUseNBT = false;
            }
        }
    }

    public static ComponentSerializer<Component, ?, String> serializer() {
        if (textUseComponent) {
            return GsonComponentSerializer.gson();
        }
        return LegacyComponentSerializer.legacySection();
    }

    public static ItemStack buildItem(Material material, String name, String ... lore) {
        return AdventureItemStack.buildItem(material, null, name, Lists.newArrayList((Object[])lore));
    }

    public static ItemStack buildItem(Material material, String name, List<String> lore) {
        return AdventureItemStack.buildItem(material, null, name, lore);
    }

    public static ItemStack buildItem(Material material, Integer customModelData, String name, String ... lore) {
        return AdventureItemStack.buildItem(material, customModelData, name, Lists.newArrayList((Object[])lore));
    }

    public static ItemStack buildItem(Material material, Integer customModelData, String name, List<String> lore) {
        if (material.equals((Object)Material.AIR)) {
            return new ItemStack(material);
        }
        ItemStack item = new ItemStack(material, 1);
        AdventureItemStack.setItemDisplayName(item, name);
        AdventureItemStack.setItemLoreMiniMessage(item, lore);
        if (customModelData != null) {
            AdventureItemStack.setCustomModelData(item, customModelData);
        }
        return item;
    }

    public static void setItemDisplayName(ItemStack item, String name) {
        if (AdventureItemStack.isEmpty(item)) {
            return;
        }
        Component displayName = AdventureUtil.miniMessage(name);
        AdventureItemStack.setItemDisplayNameByJson(item, (String)AdventureItemStack.serializer().serialize(displayName));
    }

    public static void setItemDisplayName(ItemStack item, Component name) {
        if (AdventureItemStack.isEmpty(item)) {
            return;
        }
        AdventureItemStack.setItemDisplayNameByJson(item, (String)AdventureItemStack.serializer().serialize(name));
    }

    @Nullable
    public String getItemDisplayNameAsMiniMessage(ItemStack item) {
        Component component = this.getItemDisplayName(item);
        if (component == null) {
            return null;
        }
        return AdventureUtil.miniMessage(component);
    }

    @Nullable
    public Component getItemDisplayName(ItemStack item) {
        String nameAsJson = AdventureItemStack.getItemDisplayNameAsJson(item);
        if (nameAsJson == null) {
            return null;
        }
        return AdventureItemStack.serializer().deserialize((Object)nameAsJson);
    }

    @Nullable
    public static String getItemDisplayNameAsJson(ItemStack item) {
        if (AdventureItemStack.isEmpty(item)) {
            return null;
        }
        if (itemNbtUseComponentsFormat) {
            ReadWriteNBT nbtItem = NBT.itemStackToNBT((ItemStack)item);
            ReadWriteNBT nbt2 = nbtItem.getCompound("components");
            if (nbt2 == null) {
                return null;
            }
            if (componentUseNBT) {
                ReadWriteNBT component = nbt2.hasTag("minecraft:custom_name") ? nbt2.getCompound("minecraft:custom_name") : null;
                return component != null ? component.toString() : null;
            }
            return nbt2.hasTag("minecraft:custom_name", NBTType.NBTTagString) ? nbt2.getString("minecraft:custom_name") : null;
        }
        return (String)NBT.get((ItemStack)item, nbt -> {
            ReadableNBT display = nbt.getCompound("display");
            return display != null && display.hasTag("Name", NBTType.NBTTagString) ? display.getString("Name") : null;
        });
    }

    public static void setItemDisplayNameByJson(ItemStack item, String json) {
        if (itemNbtUseComponentsFormat) {
            NBT.modifyComponents((ItemStack)item, nbt -> {
                if (componentUseNBT) {
                    ReadWriteNBT component = NBT.parseNBT((String)json);
                    nbt.set("minecraft:custom_name", (Object)component, NBTHandlers.STORE_READWRITE_TAG);
                } else {
                    nbt.setString("minecraft:custom_name", json);
                }
            });
        } else {
            NBT.modify((ItemStack)item, nbt -> {
                ReadWriteNBT display = nbt.getOrCreateCompound("display");
                display.setString("Name", json);
            });
        }
    }

    public static void setItemLoreMiniMessage(ItemStack item, String ... lore) {
        AdventureItemStack.setItemLoreMiniMessage(item, Lists.newArrayList((Object[])lore));
    }

    public static void setItemLoreMiniMessage(ItemStack item, List<String> lore) {
        if (AdventureItemStack.isEmpty(item)) {
            return;
        }
        ArrayList<String> json = new ArrayList<String>();
        for (String s : lore) {
            Component line = AdventureUtil.miniMessage(s);
            json.add((String)AdventureItemStack.serializer().serialize(line));
        }
        AdventureItemStack.setItemLoreByJson(item, json);
    }

    public static void setItemLore(ItemStack item, List<Component> lore) {
        if (AdventureItemStack.isEmpty(item)) {
            return;
        }
        ArrayList<String> json = new ArrayList<String>();
        for (Component component : lore) {
            json.add((String)AdventureItemStack.serializer().serialize(component));
        }
        AdventureItemStack.setItemLoreByJson(item, json);
    }

    @Nullable
    public static List<String> getItemLoreAsMiniMessage(ItemStack item) {
        List<Component> components = AdventureItemStack.getItemLore(item);
        if (components == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (Component component : components) {
            String s = AdventureUtil.miniMessage(component);
            lore.add(s);
        }
        return lore;
    }

    @Nullable
    public static List<Component> getItemLore(ItemStack item) {
        List<String> loreAsJson = AdventureItemStack.getItemLoreAsJson(item);
        if (loreAsJson == null) {
            return null;
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String line : loreAsJson) {
            Component component = AdventureItemStack.serializer().deserialize((Object)line);
            lore.add(component);
        }
        return lore;
    }

    @Nullable
    public static List<String> getItemLoreAsJson(ItemStack item) {
        if (AdventureItemStack.isEmpty(item)) {
            return null;
        }
        if (itemNbtUseComponentsFormat) {
            ReadWriteNBT nbtItem = NBT.itemStackToNBT((ItemStack)item);
            ReadWriteNBT nbt2 = nbtItem.getCompound("components");
            if (nbt2 == null) {
                return null;
            }
            if (componentUseNBT) {
                ReadWriteNBTCompoundList components;
                ReadWriteNBTCompoundList readWriteNBTCompoundList = components = nbt2.hasTag("minecraft:custom_name") ? nbt2.getCompoundList("minecraft:custom_name") : null;
                if (components == null) {
                    return null;
                }
                ArrayList<String> list = new ArrayList<String>();
                for (ReadWriteNBT component : components) {
                    list.add(component.toString());
                }
                return list;
            }
            return nbt2.hasTag("minecraft:custom_name", NBTType.NBTTagList) ? nbt2.getStringList("minecraft:lore").toListCopy() : null;
        }
        return (List)NBT.get((ItemStack)item, nbt -> {
            ReadableNBT display = nbt.getCompound("display");
            return display != null && display.hasTag("Lore", NBTType.NBTTagList) ? display.getStringList("Lore").toListCopy() : null;
        });
    }

    public static void setItemLoreByJson(ItemStack item, List<String> json) {
        if (itemNbtUseComponentsFormat) {
            NBT.modifyComponents((ItemStack)item, nbt -> {
                if (componentUseNBT) {
                    ReadWriteNBTCompoundList list = nbt.getCompoundList("minecraft:lore");
                    if (!list.isEmpty()) {
                        list.clear();
                    }
                    for (String s : json) {
                        ReadWriteNBT component = NBT.parseNBT((String)s);
                        list.addCompound((ReadableNBT)component);
                    }
                } else {
                    ReadWriteNBTList list = nbt.getStringList("minecraft:lore");
                    if (!list.isEmpty()) {
                        list.clear();
                    }
                    list.addAll((Collection)json);
                }
            });
        } else {
            NBT.modify((ItemStack)item, nbt -> {
                ReadWriteNBT display = nbt.getOrCreateCompound("display");
                ReadWriteNBTList list = display.getStringList("Lore");
                if (!list.isEmpty()) {
                    list.clear();
                }
                list.addAll((Collection)json);
            });
        }
    }

    public static void setCustomModelData(ItemStack item, Integer customModelData) {
        if (!MinecraftVersion.isAtLeastVersion((MinecraftVersion)MinecraftVersion.MC1_14_R1)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(customModelData);
            item.setItemMeta(meta);
        }
    }

    @Contract(value="null -> true")
    public static boolean isEmpty(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }
}

