/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func.language;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import top.mrxiaom.pluginbase.func.LanguageManager;
import top.mrxiaom.pluginbase.func.language.AbstractLanguageHolder;
import top.mrxiaom.pluginbase.func.language.Language;

public class LanguageEnumAutoHolder<T extends Enum<T>>
extends AbstractLanguageHolder {
    public final Enum<T> enumValue;

    private static <T extends Enum<T>> String key(Enum<T> enumValue) {
        String name = enumValue.name().replace("__", ".").replace("_", "-");
        Language lang = enumValue.getClass().getAnnotation(Language.class);
        return lang == null ? name : lang.prefix() + name;
    }

    public LanguageEnumAutoHolder(Enum<T> enumValue, List<String> defaultValue) {
        super(LanguageEnumAutoHolder.key(enumValue), defaultValue);
        this.enumValue = enumValue;
    }

    private LanguageEnumAutoHolder(Enum<T> enumValue, String defaultValue) {
        super(LanguageEnumAutoHolder.key(enumValue), defaultValue);
        this.enumValue = enumValue;
    }

    @Override
    public LanguageManager getLanguageManager() {
        return LanguageManager.inst();
    }

    public static <T extends Enum<T>> LanguageEnumAutoHolder<T> wrap(Enum<T> e, String defaultValue) {
        return new LanguageEnumAutoHolder<T>(e, defaultValue);
    }

    public static <T extends Enum<T>> LanguageEnumAutoHolder<T> wrap(Enum<T> e, List<String> defaultValue) {
        return new LanguageEnumAutoHolder<T>(e, defaultValue);
    }

    public static <T extends Enum<T>> LanguageEnumAutoHolder<T> wrap(Enum<T> e, String ... defaultValue) {
        ArrayList def = Lists.newArrayList((Object[])defaultValue);
        return new LanguageEnumAutoHolder<T>(e, (List<String>)def);
    }
}

