/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func.language;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import top.mrxiaom.pluginbase.func.LanguageManager;
import top.mrxiaom.pluginbase.utils.AdventureUtil;
import top.mrxiaom.pluginbase.utils.ColorHelper;
import top.mrxiaom.pluginbase.utils.Pair;

public abstract class AbstractLanguageHolder {
    public final String key;
    public final boolean isList;
    public final Object defaultValue;

    public AbstractLanguageHolder(@NotNull String key, List<String> defaultValue) {
        this.key = key;
        this.isList = true;
        this.defaultValue = defaultValue;
    }

    public AbstractLanguageHolder(@NotNull String key, String defaultValue) {
        this.key = key;
        this.isList = false;
        this.defaultValue = defaultValue;
    }

    public abstract LanguageManager getLanguageManager();

    private <T> T getOrDefault(T value) {
        return (T)(value == null ? this.defaultValue : value);
    }

    public String str() {
        LanguageManager lang = this.getLanguageManager();
        if (this.isList) {
            List<String> list = this.getOrDefault(lang.getAsList(this.key));
            return String.join((CharSequence)"\n", list);
        }
        return this.getOrDefault(lang.getAsString(this.key));
    }

    public String str(Object ... args) {
        return String.format(this.str(), args);
    }

    @SafeVarargs
    public final String str(Pair<String, Object> ... replacements) {
        return Pair.replace(this.str(), replacements);
    }

    public String str(Iterable<Pair<String, Object>> replacements) {
        return Pair.replace(this.str(), replacements);
    }

    public List<String> list() {
        LanguageManager lang = this.getLanguageManager();
        if (this.isList) {
            return this.getOrDefault(lang.getAsList(this.key));
        }
        String str = this.getOrDefault(lang.getAsString(this.key));
        return Lists.newArrayList((Object[])str.split("\n"));
    }

    public List<String> list(Object ... args) {
        return this.list().stream().map(it -> String.format(it, args)).collect(Collectors.toList());
    }

    @SafeVarargs
    public final List<String> list(Pair<String, Object> ... replacements) {
        return this.list().stream().map(it -> Pair.replace(it, replacements)).collect(Collectors.toList());
    }

    public List<String> list(Iterable<Pair<String, Object>> replacements) {
        return this.list().stream().map(it -> Pair.replace(it, replacements)).collect(Collectors.toList());
    }

    public boolean t(CommandSender receiver) {
        ColorHelper.parseAndSend(receiver, this.str());
        return true;
    }

    public boolean t(CommandSender receiver, Object ... args) {
        ColorHelper.parseAndSend(receiver, this.str(args));
        return true;
    }

    @SafeVarargs
    public final boolean t(CommandSender receiver, Pair<String, Object> ... replacements) {
        ColorHelper.parseAndSend(receiver, this.str(replacements));
        return true;
    }

    public boolean t(CommandSender receiver, Iterable<Pair<String, Object>> replacements) {
        ColorHelper.parseAndSend(receiver, this.str(replacements));
        return true;
    }

    public boolean tm(CommandSender receiver) {
        AdventureUtil.sendMessage(receiver, this.str());
        return true;
    }

    public boolean tm(CommandSender receiver, Object ... args) {
        AdventureUtil.sendMessage(receiver, this.str(args));
        return true;
    }

    @SafeVarargs
    public final boolean tm(CommandSender receiver, Pair<String, Object> ... replacements) {
        AdventureUtil.sendMessage(receiver, this.str(replacements));
        return true;
    }

    public boolean tm(CommandSender receiver, Iterable<Pair<String, Object>> replacements) {
        AdventureUtil.sendMessage(receiver, this.str(replacements));
        return true;
    }
}

