/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.utils.Pair;
import top.mrxiaom.pluginbase.utils.Util;

public class PageGuide<T> {
    List<Pair<T, ItemStack>> contents = new ArrayList<Pair<T, ItemStack>>();
    List<Integer> slots = new ArrayList<Integer>();
    List<Integer> prevPageSlots = new ArrayList<Integer>();
    List<Integer> nextPageSlots = new ArrayList<Integer>();
    ItemStack btnPrevPage;
    ItemStack btnPrevPageCannot;
    ItemStack btnNextPage;
    ItemStack btnNextPageCannot;
    int maxPage;
    int page = 1;
    Transformer<T> itemTransformer = null;

    @Nullable
    public T get(int slot) {
        int index = this.slots.indexOf(slot);
        if (index < 0) {
            return null;
        }
        int i = this.getStartIndex() + index;
        if (i < 0 || i > this.contents.size()) {
            return null;
        }
        return this.contents.get(i).getKey();
    }

    public void updateInventory(Inventory inv) {
        this.updateInventory((arg_0, arg_1) -> ((Inventory)inv).setItem(arg_0, arg_1));
    }

    public void updateInventory(InventoryView view) {
        this.updateInventory((arg_0, arg_1) -> ((InventoryView)view).setItem(arg_0, arg_1));
        HumanEntity player = view.getPlayer();
        if (player instanceof Player) {
            BukkitPlugin.getInstance().getScheduler().runTaskLater(() -> Util.submitInvUpdate((Player)player), 1L);
        }
    }

    public void updateInventory(BiConsumer<Integer, ItemStack> setItem) {
        for (int slot : this.prevPageSlots) {
            setItem.accept(slot, this.hasPrevPage() ? this.btnPrevPage : this.btnPrevPageCannot);
        }
        for (int slot : this.nextPageSlots) {
            setItem.accept(slot, this.hasNextPage() ? this.btnNextPage : this.btnNextPageCannot);
        }
        int startIndex = this.getStartIndex();
        for (int i = 0; i < this.slots.size(); ++i) {
            int index = startIndex + i;
            int slot = this.slots.get(i);
            if (index < this.contents.size()) {
                Pair<T, ItemStack> pair = this.contents.get(index);
                ItemStack item = this.itemTransformer != null ? this.itemTransformer.apply(pair.getKey(), pair.getValue(), slot, index, i, this) : pair.getValue();
                setItem.accept(slot, item);
                continue;
            }
            setItem.accept(slot, null);
        }
    }

    public boolean handlePageBtnClick(InventoryClickEvent event) {
        int slot = event.getSlot();
        if (this.slots.contains(slot)) {
            return false;
        }
        if (this.prevPageSlots.contains(slot) && this.hasPrevPage()) {
            event.setCancelled(true);
            this.prevPage();
            this.updateInventory(event.getView());
            return true;
        }
        if (this.nextPageSlots.contains(slot) && this.hasNextPage()) {
            event.setCancelled(true);
            this.nextPage();
            this.updateInventory(event.getView());
            return true;
        }
        return false;
    }

    public void setItemTransformer(Transformer<T> itemTransformer) {
        this.itemTransformer = itemTransformer;
    }

    public int getStartIndex() {
        return (this.page - 1) * this.getPerPageSize();
    }

    public int getPerPageSize() {
        return this.slots.size();
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public int getPage() {
        return this.page;
    }

    public void reCalcMaxPage() {
        this.maxPage = this.slots.isEmpty() || this.contents.isEmpty() ? 1 : (int)Math.ceil((double)this.contents.size() / (double)this.slots.size());
    }

    public boolean hasNextPage() {
        return this.getPage() < this.getMaxPage();
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.page;
        }
    }

    public boolean hasPrevPage() {
        return this.getPage() > 1;
    }

    public void prevPage() {
        if (this.hasPrevPage()) {
            --this.page;
        }
    }

    public void setContentSlots(int ... slots) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int slot : slots) {
            list.add(slot);
        }
        this.setContentSlots(list);
    }

    public void setContentSlots(List<Integer> slots) {
        this.slots = slots;
        this.reCalcMaxPage();
    }

    public void add(T data, ItemStack display) {
        this.contents.add(Pair.of(data, display));
        this.reCalcMaxPage();
    }

    public boolean contains(T data) {
        for (Pair<T, ItemStack> content : this.contents) {
            if (!content.getKey().equals(data)) continue;
            return true;
        }
        return false;
    }

    public void remove(T data) {
        this.contents.removeIf(it -> it.getKey().equals(data));
        this.reCalcMaxPage();
    }

    public void clear() {
        this.contents.clear();
        this.reCalcMaxPage();
    }

    public List<Pair<T, ItemStack>> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public void setupPrevPageButton(ItemStack prevPage, ItemStack cannot, int ... slots) {
        this.btnPrevPage = prevPage;
        this.btnPrevPageCannot = cannot;
        this.prevPageSlots.clear();
        for (int slot : slots) {
            this.prevPageSlots.add(slot);
        }
    }

    public void setupNextPageButton(ItemStack nextPage, ItemStack cannot, int ... slots) {
        this.btnNextPage = nextPage;
        this.btnNextPageCannot = cannot;
        this.nextPageSlots.clear();
        for (int slot : slots) {
            this.nextPageSlots.add(slot);
        }
    }

    @FunctionalInterface
    public static interface Transformer<T> {
        @Nullable
        public ItemStack apply(T var1, @Nullable ItemStack var2, int var3, int var4, int var5, PageGuide<T> var6);
    }
}

