/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func.gui;

import com.google.common.collect.Lists;
import de.tr7zw.changeme.nbtapi.NBT;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.actions.ActionProviders;
import top.mrxiaom.pluginbase.api.IAction;
import top.mrxiaom.pluginbase.func.gui.IModifier;
import top.mrxiaom.pluginbase.func.gui.ITagProvider;
import top.mrxiaom.pluginbase.utils.AdventureItemStack;
import top.mrxiaom.pluginbase.utils.ItemStackUtil;
import top.mrxiaom.pluginbase.utils.PAPI;
import top.mrxiaom.pluginbase.utils.Pair;
import top.mrxiaom.pluginbase.utils.Util;

public class LoadedIcon {
    private static final List<ITagProvider> tagProviders = new ArrayList<ITagProvider>();
    private final boolean adventure;
    public final String material;
    public final int amount;
    public final String display;
    public final List<String> lore;
    public final boolean glow;
    public final Integer customModelData;
    public final Map<String, String> nbtStrings;
    public final Map<String, String> nbtInts;
    public final List<IAction> leftClickCommands;
    public final List<IAction> rightClickCommands;
    public final List<IAction> shiftLeftClickCommands;
    public final List<IAction> shiftRightClickCommands;
    public final List<IAction> dropCommands;
    public final Object tag;

    LoadedIcon(boolean adventure, String material, int amount, String display, List<String> lore, boolean glow, Integer customModelData, Map<String, String> nbtStrings, Map<String, String> nbtInts, List<IAction> leftClickCommands, List<IAction> rightClickCommands, List<IAction> shiftLeftClickCommands, List<IAction> shiftRightClickCommands, List<IAction> dropCommands, Object tag) {
        this.adventure = adventure;
        this.material = material.toUpperCase();
        this.amount = amount;
        this.display = display;
        this.lore = lore;
        this.glow = glow;
        this.customModelData = customModelData;
        this.nbtStrings = nbtStrings;
        this.nbtInts = nbtInts;
        this.leftClickCommands = leftClickCommands;
        this.rightClickCommands = rightClickCommands;
        this.shiftLeftClickCommands = shiftLeftClickCommands;
        this.shiftRightClickCommands = shiftRightClickCommands;
        this.dropCommands = dropCommands;
        this.tag = tag;
    }

    public ItemStack generateIcon(Player player) {
        return this.generateIcon(player, null, null);
    }

    public ItemStack generateIcon(Player player, @Nullable IModifier<String> displayNameModifier, @Nullable IModifier<List<String>> loreModifier) {
        if (this.material.equals("AIR") || this.amount == 0) {
            return new ItemStack(Material.AIR);
        }
        Pair<Material, Integer> pair = ItemStackUtil.parseMaterial(this.material);
        ItemStack item = pair == null ? new ItemStack(Material.PAPER) : ItemStackUtil.legacy(pair);
        return this.generateIcon(item, player, displayNameModifier, loreModifier);
    }

    public ItemStack generateIcon(ItemStack item, Player player) {
        return this.generateIcon(item, player, null, null);
    }

    public ItemStack generateIcon(ItemStack item, Player player, @Nullable IModifier<String> displayNameModifier, @Nullable IModifier<List<String>> loreModifier) {
        if (item == null || this.amount == 0) {
            return new ItemStack(Material.AIR);
        }
        item.setAmount(this.amount);
        if (!this.display.isEmpty()) {
            String displayName = PAPI.setPlaceholders(player, IModifier.fit(displayNameModifier, this.display));
            if (this.adventure) {
                AdventureItemStack.setItemDisplayName(item, displayName);
            } else {
                ItemStackUtil.setItemDisplayName(item, displayName);
            }
        }
        if (!this.lore.isEmpty()) {
            List<String> loreList = PAPI.setPlaceholders(player, IModifier.fit(loreModifier, this.lore));
            if (this.adventure) {
                AdventureItemStack.setItemLoreMiniMessage(item, loreList);
            } else {
                ItemStackUtil.setItemLore(item, loreList);
            }
        }
        if (this.glow) {
            ItemStackUtil.setGlow(item);
        }
        if (this.customModelData != null) {
            ItemStackUtil.setCustomModelData(item, this.customModelData);
        }
        if (!this.nbtStrings.isEmpty() || !this.nbtInts.isEmpty()) {
            NBT.modify((ItemStack)item, nbt -> {
                String value;
                for (Map.Entry<String, String> entry : this.nbtStrings.entrySet()) {
                    value = PAPI.setPlaceholders(player, entry.getValue());
                    nbt.setString(entry.getKey(), value);
                }
                for (Map.Entry<String, String> entry : this.nbtInts.entrySet()) {
                    value = PAPI.setPlaceholders(player, entry.getValue());
                    Integer i = Util.parseInt(value).orElse(null);
                    if (i == null) continue;
                    nbt.setInteger(entry.getKey(), i);
                }
            });
        }
        return item;
    }

    public void click(Player player, ClickType type) {
        List<IAction> actions;
        switch (type) {
            case LEFT: {
                actions = this.leftClickCommands;
                break;
            }
            case RIGHT: {
                actions = this.rightClickCommands;
                break;
            }
            case SHIFT_LEFT: {
                actions = this.shiftLeftClickCommands;
                break;
            }
            case SHIFT_RIGHT: {
                actions = this.shiftRightClickCommands;
                break;
            }
            case DROP: {
                actions = this.dropCommands;
                break;
            }
            default: {
                return;
            }
        }
        ArrayList args = Lists.newArrayList((Object[])new Pair[]{Pair.of("__internal__loaded_icon", this)});
        for (IAction action : actions) {
            action.run(player, args);
        }
    }

    public static LoadedIcon load(ConfigurationSection section, String id) {
        ITagProvider provider;
        String materialStr = section.getString(id + ".material");
        String material = materialStr != null ? (!materialStr.contains(":") && section.contains(id + ".data") ? materialStr + ":" + section.getInt(id + ".data") : materialStr) : "PAPER";
        int amount = section.getInt(id + ".amount", 1);
        String display = section.getString(id + ".display", "");
        List lore = section.getStringList(id + ".lore");
        boolean glow = section.getBoolean(id + ".glow");
        Integer customModelData = section.contains(id + ".custom-model-data") ? Integer.valueOf(section.getInt(id + ".custom-model-data")) : null;
        HashMap<String, String> nbtStrings = new HashMap<String, String>();
        ConfigurationSection section1 = section.getConfigurationSection(id + ".nbt-strings");
        if (section1 != null) {
            for (Object key : section1.getKeys(false)) {
                nbtStrings.put((String)key, section1.getString((String)key, ""));
            }
        }
        HashMap<String, String> nbtInts = new HashMap<String, String>();
        section1 = section.getConfigurationSection(id + ".nbt-ints");
        if (section1 != null) {
            for (String key : section1.getKeys(false)) {
                nbtInts.put(key, section1.getString(key, ""));
            }
        }
        List<IAction> leftClickCommands = ActionProviders.loadActions(section, id + ".left-click-commands");
        List<IAction> rightClickCommands = ActionProviders.loadActions(section, id + ".right-click-commands");
        List<IAction> shiftLeftClickCommands = ActionProviders.loadActions(section, id + ".shift-left-click-commands");
        List<IAction> shiftRightClickCommands = ActionProviders.loadActions(section, id + ".shift-left-click-commands");
        List<IAction> dropCommands = ActionProviders.loadActions(section, id + ".drop-commands");
        Object tag = null;
        Iterator<ITagProvider> iterator = tagProviders.iterator();
        while (iterator.hasNext() && (tag = (provider = iterator.next()).provide(section, id)) == null) {
        }
        return new LoadedIcon(BukkitPlugin.getInstance().options.adventure(), material, amount, display, lore, glow, customModelData, nbtStrings, nbtInts, leftClickCommands, rightClickCommands, shiftLeftClickCommands, shiftRightClickCommands, dropCommands, tag);
    }

    public static void registerTagProvider(ITagProvider provider) {
        tagProviders.add(provider);
        tagProviders.sort(Comparator.comparingInt(ITagProvider::priority));
    }
}

