/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AbstractPluginHolder;
import top.mrxiaom.pluginbase.func.language.AbstractLanguageHolder;
import top.mrxiaom.pluginbase.func.language.LanguageEnumAutoHolder;

public class LanguageManager
extends AbstractPluginHolder<BukkitPlugin> {
    private final Map<String, Function> holderGetters = new HashMap<String, Function>();
    private final Map<String, Object> holderValues = new HashMap<String, Object>();
    private final Map<String, AbstractLanguageHolder> holders = new HashMap<String, AbstractLanguageHolder>();
    private File file = null;
    private boolean disableReloadConfig = false;
    private String keyPrefix = "";

    public LanguageManager(BukkitPlugin plugin) {
        super(plugin, true);
    }

    @Nullable
    public File getLangFile() {
        return this.file;
    }

    public LanguageManager setLangFile(@Nullable String langFile) {
        if (langFile == null) {
            return this.setLangFile((File)null);
        }
        return this.setLangFile(new File(this.plugin.getDataFolder(), langFile));
    }

    public LanguageManager setLangFile(@Nullable File file) {
        this.file = file;
        return this;
    }

    public boolean isDisableReloadConfig() {
        return this.disableReloadConfig;
    }

    public LanguageManager setDisableReloadConfig(boolean disableReloadConfig) {
        this.disableReloadConfig = disableReloadConfig;
        return this;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public LanguageManager setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public <T extends Enum<T>> LanguageManager register(Class<T> enumType, Function<T, LanguageEnumAutoHolder<T>> getter) {
        this.holderGetters.put(enumType.getName(), getter);
        for (Enum value : (Enum[])enumType.getEnumConstants()) {
            LanguageEnumAutoHolder<T> holder = getter.apply(value);
            this.holders.put(holder.key, holder);
        }
        return this;
    }

    @Nullable
    public <T extends Enum<T>> LanguageEnumAutoHolder<T> getHolderByEnum(T value) {
        Function getter = this.holderGetters.get(value.getClass().getName());
        if (getter == null) {
            return null;
        }
        return (LanguageEnumAutoHolder)getter.apply(value);
    }

    public List<AbstractLanguageHolder> getHolders() {
        return Lists.newArrayList(this.holders.values());
    }

    @Nullable
    public String getAsString(String key) {
        Object obj = this.holderValues.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    @Nullable
    public List<String> getAsList(String key) {
        Object obj = this.holderValues.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    @Override
    public void reloadConfig(MemoryConfiguration config) {
        if (this.disableReloadConfig) {
            return;
        }
        this.reload();
    }

    public LanguageManager reload() {
        if (this.file == null || this.holders.isEmpty()) {
            return this;
        }
        this.holderValues.clear();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.file);
        config.setDefaults((Configuration)new YamlConfiguration());
        for (AbstractLanguageHolder holder : this.holders.values()) {
            if (!config.contains(holder.key)) {
                config.set(this.keyPrefix + holder.key, holder.defaultValue);
                continue;
            }
            if (holder.isList) {
                this.holderValues.put(this.keyPrefix + holder.key, config.getStringList(holder.key));
                continue;
            }
            this.holderValues.put(this.keyPrefix + holder.key, config.getString(holder.key));
        }
        try {
            config.save(this.file);
        }
        catch (IOException e) {
            this.warn("\u66f4\u65b0\u8bed\u8a00\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        return this;
    }

    public static LanguageManager inst() {
        return LanguageManager.instanceOf(LanguageManager.class);
    }
}

