/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AbstractPluginHolder;
import top.mrxiaom.pluginbase.gui.IGui;

public class GuiManager
extends AbstractPluginHolder<BukkitPlugin>
implements Listener {
    final Map<UUID, IGui> playersGui = new HashMap<UUID, IGui>();
    BiConsumer<Player, IGui> disable = (player, gui) -> {
        try {
            player.sendTitle("\u00a7e\u8bf7\u7b49\u7b49", "\u00a7f\u7ba1\u7406\u5458\u6b63\u5728\u66f4\u65b0\u63d2\u4ef6", 10, 30, 10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    };
    boolean disabled = false;

    public GuiManager(BukkitPlugin plugin) {
        super(plugin, true);
        this.registerEvents(this);
    }

    public void openGui(IGui gui) {
        if (this.disabled) {
            return;
        }
        Player player = gui.getPlayer();
        if (player == null) {
            return;
        }
        player.closeInventory();
        this.playersGui.put(player.getUniqueId(), gui);
        Inventory inv = gui.newInventory();
        if (inv != null) {
            player.openInventory(inv);
        }
    }

    @Override
    public void onDisable() {
        this.disabled = true;
        ArrayList entries = Lists.newArrayList(this.playersGui.entrySet());
        for (Map.Entry entry : entries) {
            Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
            if (player == null) continue;
            ((IGui)entry.getValue()).onClose(player.getOpenInventory());
            this.playersGui.remove(entry.getKey());
            player.closeInventory();
            if (this.disable == null) continue;
            this.disable.accept(player, (IGui)entry.getValue());
        }
    }

    public void setDisableAction(@Nullable BiConsumer<Player, IGui> consumer) {
        this.disable = consumer;
    }

    @Nullable
    public IGui getOpeningGui(Player player) {
        if (this.disabled) {
            return null;
        }
        return this.playersGui.get(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        if (this.disabled) {
            return;
        }
        Player player = e.getPlayer();
        IGui remove = this.playersGui.remove(player.getUniqueId());
        if (remove != null) {
            remove.onClose(player.getOpenInventory());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.disabled || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.playersGui.containsKey(player.getUniqueId())) {
            this.playersGui.get(player.getUniqueId()).onClick(event.getAction(), event.getClick(), event.getSlotType(), event.getRawSlot(), event.getCurrentItem(), event.getCursor(), event.getView(), event);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.disabled || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (this.playersGui.containsKey(player.getUniqueId())) {
            this.playersGui.get(player.getUniqueId()).onDrag(event.getView(), event);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.disabled || !(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        IGui remove = this.playersGui.remove(player.getUniqueId());
        if (remove != null) {
            remove.onClose(event.getView());
        }
    }

    public static GuiManager inst() {
        return GuiManager.instanceOf(GuiManager.class);
    }
}

