/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AutoRegister;
import top.mrxiaom.pluginbase.utils.ColorHelper;
import top.mrxiaom.pluginbase.utils.Util;

public abstract class AbstractPluginHolder<T extends BukkitPlugin> {
    private static final Map<Class<?>, AbstractPluginHolder<?>> registeredBungeeHolders = new HashMap();
    private static final Map<Class<?>, AbstractPluginHolder<?>> registeredHolders = new HashMap();
    public final T plugin;

    public AbstractPluginHolder(BukkitPlugin plugin) {
        this(plugin, false);
    }

    public AbstractPluginHolder(BukkitPlugin plugin, boolean register) {
        this.plugin = plugin;
        if (register) {
            this.register();
        }
    }

    public static void loadModules(BukkitPlugin plugin, List<Class<? extends AbstractPluginHolder<?>>> classList) {
        for (Class<AbstractPluginHolder<?>> clazz : classList) {
            try {
                Constructor<AbstractPluginHolder<?>> constructor;
                AutoRegister meta = clazz.getAnnotation(AutoRegister.class);
                if (meta != null) {
                    boolean load = true;
                    for (String s : meta.requirePlugins()) {
                        if (Bukkit.getPluginManager().isPluginEnabled(s)) continue;
                        load = false;
                        break;
                    }
                    if (!load) continue;
                }
                try {
                    constructor = clazz.getDeclaredConstructor(BukkitPlugin.class);
                }
                catch (Throwable t) {
                    constructor = clazz.getDeclaredConstructor(((Object)((Object)plugin)).getClass());
                }
                constructor.newInstance(new Object[]{plugin});
            }
            catch (Throwable t) {
                plugin.warn("\u52a0\u8f7d " + clazz.getName() + "\u65f6\u51fa\u73b0\u5f02\u5e38:", t);
            }
        }
    }

    public int priority() {
        return 1000;
    }

    public void receiveBungee(String subChannel, DataInputStream in) throws IOException {
    }

    public static void receiveFromBungee(String subChannel, byte[] bytes) {
        ArrayList holders = new ArrayList(registeredBungeeHolders.values());
        holders.sort(Comparator.comparingInt(AbstractPluginHolder::priority));
        for (AbstractPluginHolder<?> holder : registeredBungeeHolders.values()) {
            try {
                DataInputStream msgIn = new DataInputStream(new ByteArrayInputStream(bytes));
                Throwable throwable = null;
                try {
                    holder.receiveBungee(subChannel, msgIn);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (msgIn == null) continue;
                    if (throwable != null) {
                        try {
                            msgIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    msgIn.close();
                }
            }
            catch (Throwable t) {
                BukkitPlugin.getInstance().warn("\u63a5\u6536\u5904\u7406\u6765\u81ea BungeeCord \u7684\u6d88\u606f\u65f6\u51fa\u73b0\u9519\u8bef", t);
            }
        }
        holders.clear();
    }

    public void reloadConfig(MemoryConfiguration config) {
    }

    public static void reloadAllConfig(MemoryConfiguration config) {
        ArrayList holders = new ArrayList(registeredHolders.values());
        holders.sort(Comparator.comparingInt(AbstractPluginHolder::priority));
        for (AbstractPluginHolder abstractPluginHolder : holders) {
            abstractPluginHolder.reloadConfig(config);
        }
        holders.clear();
    }

    public static Set<String> keys(ConfigurationSection section, String key) {
        ConfigurationSection s = section == null ? null : section.getConfigurationSection(key);
        return s == null ? new HashSet() : s.getKeys(false);
    }

    public void onDisable() {
    }

    public static void callDisable() {
        ArrayList holders = new ArrayList(registeredHolders.values());
        holders.sort(Comparator.comparingInt(AbstractPluginHolder::priority));
        for (AbstractPluginHolder abstractPluginHolder : holders) {
            abstractPluginHolder.onDisable();
        }
        holders.clear();
        registeredHolders.clear();
        registeredBungeeHolders.clear();
    }

    protected void registerEvents() {
        if (this instanceof Listener) {
            this.registerEvents((Listener)this);
        }
    }

    protected void registerEvents(Listener listener) {
        try {
            Bukkit.getPluginManager().registerEvents(listener, this.plugin);
        }
        catch (Throwable t) {
            this.warn("\u5728\u6ce8\u518c\u4e8b\u4ef6\u76d1\u542c\u5668 " + this.getClass().getSimpleName() + " \u65f6\u51fa\u73b0\u4e00\u4e2a\u5f02\u5e38", t);
        }
    }

    protected void registerCommand(String label, Object inst) {
        PluginCommand command = this.plugin.getCommand(label);
        if (command != null) {
            if (inst instanceof CommandExecutor) {
                command.setExecutor((CommandExecutor)inst);
            } else {
                this.warn(inst.getClass().getSimpleName() + " \u4e0d\u662f\u4e00\u4e2a\u547d\u4ee4\u6267\u884c\u5668");
            }
            if (inst instanceof TabCompleter) {
                command.setTabCompleter((TabCompleter)inst);
            }
        } else {
            this.info("\u65e0\u6cd5\u6ce8\u518c\u547d\u4ee4 /" + label);
        }
    }

    protected void register() {
        registeredHolders.put(this.getClass(), this);
    }

    protected void unregister() {
        registeredHolders.remove(this.getClass());
    }

    protected boolean isRegistered() {
        return registeredHolders.containsKey(this.getClass());
    }

    protected void registerBungee() {
        registeredBungeeHolders.put(this.getClass(), this);
    }

    protected void unregisterBungee() {
        registeredBungeeHolders.remove(this.getClass());
    }

    protected boolean isRegisteredBungee() {
        return registeredBungeeHolders.containsKey(this.getClass());
    }

    public void info(String ... lines) {
        for (String line : lines) {
            this.plugin.getLogger().info(line);
        }
    }

    public void warn(String ... lines) {
        for (String line : lines) {
            this.plugin.getLogger().warning(line);
        }
    }

    public void warn(Throwable t) {
        this.plugin.getLogger().warning(Util.stackTraceToString(t));
    }

    public void warn(String s, Throwable t) {
        this.plugin.getLogger().warning(s);
        this.plugin.getLogger().warning(Util.stackTraceToString(t));
    }

    @Nullable
    public static <T extends AbstractPluginHolder<?>> T getOrNull(Class<T> clazz) {
        return (T)registeredHolders.get(clazz);
    }

    public static <T extends AbstractPluginHolder<?>> Optional<T> get(Class<T> clazz) {
        AbstractPluginHolder<?> inst = registeredHolders.get(clazz);
        if (inst == null) {
            return Optional.empty();
        }
        return Optional.of(inst);
    }

    protected static <T extends AbstractPluginHolder<?>> T instanceOf(Class<T> clazz) {
        AbstractPluginHolder<?> inst = registeredHolders.get(clazz);
        if (inst == null) {
            throw new IllegalStateException("\u65e0\u6cd5\u627e\u5230\u5df2\u6ce8\u518c\u7684 " + clazz.getName());
        }
        return (T)inst;
    }

    public static boolean t(CommandSender sender, String ... msg) {
        ColorHelper.parseAndSend(sender, String.join((CharSequence)"\n&r", msg));
        return true;
    }
}

