/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AbstractGuiModule;
import top.mrxiaom.pluginbase.func.AbstractModule;
import top.mrxiaom.pluginbase.func.gui.IModel;
import top.mrxiaom.pluginbase.func.gui.LoadedIcon;
import top.mrxiaom.pluginbase.gui.IGui;

public abstract class AbstractGuisModule<T extends BukkitPlugin, M extends IModel>
extends AbstractModule<T> {
    private final String warningPrefix;
    protected Map<String, M> menus = new TreeMap<String, M>(String.CASE_INSENSITIVE_ORDER);

    public AbstractGuisModule(BukkitPlugin plugin, String warningPrefix) {
        super(plugin);
        this.warningPrefix = warningPrefix;
    }

    @Override
    public void reloadConfig(MemoryConfiguration cfg) {
        this.menus.clear();
    }

    public <P extends AbstractGuisModule<T, M>> void loadConfig(P parent, File file, String id, IModelProvider<P, M> provider) {
        if (this.menus.containsKey(id)) {
            this.warn(this.warningPrefix + "\u91cd\u590d\u83dc\u5355 " + id);
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        M loaded = provider.load(parent, (ConfigurationSection)config, id);
        if (loaded != null) {
            this.menus.put(id, loaded);
        }
    }

    @NotNull
    public Set<String> keys(Permissible p) {
        if (p.isOp()) {
            return this.keys();
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, M> entry : this.menus.entrySet()) {
            if (!((IModel)entry.getValue()).hasPermission(p)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    @NotNull
    public Set<String> keys() {
        return this.menus.keySet();
    }

    @Nullable
    public M get(String id) {
        return (M)((IModel)this.menus.get(id));
    }

    public static abstract class Gui<M extends IModel>
    implements IGui,
    InventoryHolder {
        protected Player player;
        protected M model;
        protected String title;
        protected char[] inventory;
        protected Inventory created;
        protected Map<Character, LoadedIcon> otherIcons;
        protected boolean legacy;

        protected Gui(@NotNull Player player, @NotNull M model) {
            this.player = player;
            this.model = model;
            this.title = model.title();
            this.inventory = model.inventory();
            this.otherIcons = model.otherIcons();
        }

        @Override
        public Player getPlayer() {
            return this.player;
        }

        @NotNull
        public Inventory getInventory() {
            return this.created;
        }

        public void updateInventory(BiConsumer<Integer, ItemStack> setItem) {
            HashMap<Character, Integer> appearMap = new HashMap<Character, Integer>();
            for (int i = 0; i < this.inventory.length; ++i) {
                char id = this.inventory[i];
                if (id == ' ' || id == '\u3000') {
                    setItem.accept(i, null);
                    continue;
                }
                int appearTimes = appearMap.getOrDefault(Character.valueOf(id), 0) + 1;
                appearMap.put(Character.valueOf(id), appearTimes);
                AtomicBoolean ignore = new AtomicBoolean(false);
                ItemStack item = this.model.applyMainIcon(this, this.player, id, i, appearTimes, ignore);
                if (ignore.get()) continue;
                if (item != null) {
                    setItem.accept(i, item);
                    continue;
                }
                LoadedIcon icon = this.otherIcons.get(Character.valueOf(id));
                if (icon != null) {
                    setItem.accept(i, icon.generateIcon(this.player));
                    continue;
                }
                setItem.accept(i, null);
            }
        }

        public void updateInventory(Inventory inv) {
            this.updateInventory((arg_0, arg_1) -> ((Inventory)inv).setItem(arg_0, arg_1));
        }

        public void updateInventory(InventoryView view) {
            this.updateInventory((arg_0, arg_1) -> ((InventoryView)view).setItem(arg_0, arg_1));
            this.player.updateInventory();
        }

        @Override
        public Inventory newInventory() {
            Inventory inv = this.create(this.inventory.length, this.title);
            this.updateInventory(inv);
            return inv;
        }

        protected Inventory create(int size, String title) {
            this.created = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)title);
            return this.created;
        }

        public Character getClickedId(int slot) {
            return AbstractGuiModule.getClickedId(this.inventory, slot);
        }

        public int getAppearTimes(Character id, int slot) {
            return AbstractGuiModule.getAppearTimes(this.inventory, id, slot);
        }

        public void handleOtherClick(ClickType type, int slot) {
            LoadedIcon icon;
            Character id = this.getClickedId(slot);
            if (id != null && (icon = this.otherIcons.get(id)) != null) {
                icon.click(this.player, type);
            }
        }
    }

    public static interface IModelProvider<P extends AbstractGuisModule<?, M>, M extends IModel> {
        @Nullable
        public M load(P var1, ConfigurationSection var2, String var3);
    }
}

