/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.func;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.func.AbstractModule;
import top.mrxiaom.pluginbase.func.gui.LoadedIcon;
import top.mrxiaom.pluginbase.gui.IGui;

public abstract class AbstractGuiModule<T extends BukkitPlugin>
extends AbstractModule<T> {
    protected final File file;
    protected String guiTitle;
    protected char[] guiInventory;
    private final String mainIconsKey;
    private final String otherIconsKey;
    protected final Map<Character, LoadedIcon> otherIcons = new HashMap<Character, LoadedIcon>();

    public AbstractGuiModule(BukkitPlugin plugin, File file) {
        this(plugin, file, "main-icons", "other-icons");
    }

    public AbstractGuiModule(BukkitPlugin plugin, File file, @Nullable String mainIconsKey, @Nullable String otherIconsKey) {
        super(plugin);
        this.file = file;
        this.mainIconsKey = mainIconsKey;
        this.otherIconsKey = otherIconsKey;
    }

    protected abstract String warningPrefix();

    @Override
    public void reloadConfig(MemoryConfiguration cfg) {
        LoadedIcon icon;
        ConfigurationSection section;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.file);
        this.guiTitle = config.getString("title", "");
        this.guiInventory = AbstractGuiModule.getInventory((ConfigurationSection)config, "inventory");
        this.reloadMenuConfig(config);
        if (this.mainIconsKey != null && (section = config.getConfigurationSection(this.mainIconsKey)) != null) {
            for (String key : section.getKeys(false)) {
                icon = LoadedIcon.load(section, key);
                this.loadMainIcon(section, key, icon);
            }
        }
        if (this.otherIconsKey != null) {
            this.otherIcons.clear();
            section = config.getConfigurationSection(this.otherIconsKey);
            if (section != null) {
                for (String key : section.getKeys(false)) {
                    icon = LoadedIcon.load(section, key);
                    if (key.length() != 1) {
                        this.warn(this.warningPrefix() + " \u5176\u5b83\u56fe\u6807 " + key + " \u7684\u56fe\u6807ID\u8fc7\u957f\uff0c\u8bf7\u6539\u6210\u5355\u4e2a\u5b57\u7b26");
                        continue;
                    }
                    this.otherIcons.put(Character.valueOf(key.charAt(0)), icon);
                }
            }
        }
    }

    protected void reloadMenuConfig(YamlConfiguration config) {
    }

    protected abstract void loadMainIcon(ConfigurationSection var1, String var2, LoadedIcon var3);

    protected ItemStack applyMainIcon(IGui instance, Player player, char id, int index, int appearTimes) {
        return null;
    }

    protected ItemStack applyMainIcon(IGui instance, Player player, char id, int index, int appearTimes, AtomicBoolean ignore) {
        return this.applyMainIcon(instance, player, id, index, appearTimes);
    }

    public static char[] getInventory(ConfigurationSection config, String key) {
        return String.join((CharSequence)"", config.getStringList(key)).toCharArray();
    }

    @Nullable
    public static Character getClickedId(char[] inventory, int slot) {
        if (slot >= 0 && slot < inventory.length) {
            return Character.valueOf(inventory[slot]);
        }
        return null;
    }

    public static int getAppearTimes(char[] inventory, Character id, int slot) {
        int appearTimes = 0;
        for (int i = 0; i < inventory.length; ++i) {
            if (id.equals(Character.valueOf(inventory[i]))) {
                ++appearTimes;
            }
            if (i == slot) break;
        }
        return appearTimes;
    }

    public abstract class Gui
    implements IGui {
        protected Player player;
        protected String title;
        protected char[] inventory;

        protected Gui(Player player, String title, char[] inventory) {
            this.player = player;
            this.title = title;
            this.inventory = inventory;
        }

        @Override
        public Player getPlayer() {
            return this.player;
        }

        public void updateInventory(BiConsumer<Integer, ItemStack> setItem) {
            HashMap<Character, Integer> appearMap = new HashMap<Character, Integer>();
            for (int i = 0; i < this.inventory.length; ++i) {
                char id = this.inventory[i];
                if (id == ' ' || id == '\u3000') {
                    setItem.accept(i, null);
                    continue;
                }
                int appearTimes = appearMap.getOrDefault(Character.valueOf(id), 0) + 1;
                appearMap.put(Character.valueOf(id), appearTimes);
                AtomicBoolean ignore = new AtomicBoolean(false);
                ItemStack item = AbstractGuiModule.this.applyMainIcon(this, this.player, id, i, appearTimes, ignore);
                if (ignore.get()) continue;
                if (item != null) {
                    setItem.accept(i, item);
                    continue;
                }
                LoadedIcon icon = AbstractGuiModule.this.otherIcons.get(Character.valueOf(id));
                if (icon != null) {
                    setItem.accept(i, icon.generateIcon(this.player));
                    continue;
                }
                setItem.accept(i, null);
            }
        }

        public void updateInventory(Inventory inv) {
            this.updateInventory((arg_0, arg_1) -> ((Inventory)inv).setItem(arg_0, arg_1));
        }

        public void updateInventory(InventoryView view) {
            this.updateInventory((arg_0, arg_1) -> ((InventoryView)view).setItem(arg_0, arg_1));
            this.player.updateInventory();
        }

        @Override
        public Inventory newInventory() {
            Inventory inv = this.create(null, this.inventory.length, this.title);
            this.updateInventory(inv);
            return inv;
        }

        protected Inventory create(InventoryHolder holder, int size, String title) {
            return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)title);
        }

        public Character getClickedId(int slot) {
            return AbstractGuiModule.getClickedId(this.inventory, slot);
        }

        public int getAppearTimes(Character id, int slot) {
            return AbstractGuiModule.getAppearTimes(this.inventory, id, slot);
        }

        public void handleOtherClick(ClickType type, int slot) {
            LoadedIcon icon;
            Character id = this.getClickedId(slot);
            if (id != null && (icon = AbstractGuiModule.this.otherIcons.get(id)) != null) {
                icon.click(this.player, type);
            }
        }
    }
}

