/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase.actions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import top.mrxiaom.pluginbase.api.IAction;
import top.mrxiaom.pluginbase.api.IActionProvider;

public class ActionProviders {
    private static final List<IActionProvider> actionProviders = new ArrayList<IActionProvider>();

    private ActionProviders() {
    }

    public static List<IAction> loadActions(ConfigurationSection section, String key) {
        List list = section.getStringList(key);
        return ActionProviders.loadActions(list);
    }

    public static List<IAction> loadActions(List<String> list) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        for (String s : list) {
            for (IActionProvider provider : actionProviders) {
                IAction action = provider.provide(s);
                if (action == null) continue;
                actions.add(action);
            }
        }
        return actions;
    }

    public static void registerActionProvider(IActionProvider provider) {
        actionProviders.add(provider);
        actionProviders.sort(Comparator.comparingInt(IActionProvider::priority));
    }
}

