/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import top.mrxiaom.pluginbase.BukkitPlugin;

public class EconomyHolder {
    BukkitPlugin plugin;
    Economy economy;

    protected EconomyHolder(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void load() {
        RegisteredServiceProvider economyProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
    }

    public double get(OfflinePlayer player) {
        if (this.economy == null) {
            return 0.0;
        }
        return this.economy.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double money) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.has(player, money);
    }

    public void giveMoney(OfflinePlayer player, double money) {
        if (this.economy == null) {
            return;
        }
        this.economy.depositPlayer(player, money);
    }

    public void takeMoney(OfflinePlayer player, double money) {
        if (this.economy == null) {
            return;
        }
        this.economy.withdrawPlayer(player, money);
    }
}

