/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import top.mrxiaom.pluginbase.BukkitPlugin;
import top.mrxiaom.pluginbase.database.IDatabase;
import top.mrxiaom.pluginbase.utils.Util;

public class DatabaseHolder {
    BukkitPlugin plugin;
    HikariConfig hikariConfig;
    HikariDataSource dataSource = null;
    List<IDatabase> databases = new ArrayList<IDatabase>();
    private boolean firstConnectFlag = false;
    private String tablePrefix;
    private String driver;
    private String version = "unknown";

    protected DatabaseHolder(BukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerDatabase(IDatabase ... databases) {
        this.databases.addAll(Arrays.asList(databases));
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getDriver() {
        return this.driver;
    }

    public boolean isSQLite() {
        return "org.sqlite.JDBC".equals(this.getDriver());
    }

    public boolean isMySQL() {
        return "com.mysql.cj.jdbc.Driver".equals(this.getDriver()) || "com.mysql.jdbc.Driver".equals(this.getDriver());
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Throwable t) {
            this.plugin.getLogger().warning(Util.stackTraceToString(t));
            return null;
        }
    }

    public void reloadConfig() {
        File file = new File(this.plugin.getDataFolder(), "database.yml");
        if (!file.exists()) {
            this.plugin.saveResource("database.yml", true);
        }
        this.reloadFromFile(file);
    }

    private void reloadFromFile(File file) {
        String type;
        File gotoFile;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (config.contains("goto") && (gotoFile = new File(config.getString("goto", ""))).exists() && gotoFile.isFile()) {
            this.reloadFromFile(gotoFile);
            return;
        }
        this.tablePrefix = config.getString("table_prefix", "");
        switch (type = config.getString("type", "sqlite").toLowerCase()) {
            case "mysql": {
                int mysqlVersion = config.getInt("mysql.version", 8);
                if (mysqlVersion == 8 && Util.isPresent("com.mysql.cj.jdbc.Driver")) {
                    this.driver = this.checkDriver("MySQL", "com.mysql.cj.jdbc.Driver");
                    break;
                }
                this.driver = this.checkDriver("MySQL", "com.mysql.jdbc.Driver");
                if (this.driver != null) {
                    if (mysqlVersion != 8) break;
                    this.driver = null;
                    this.plugin.warn("\u4f60\u5728\u6570\u636e\u5e93\u914d\u7f6e\u4e2d\u6307\u5b9a\u4e86 MySQL \u7248\u672c\u4e3a 8\uff0c\u4f46\u63d2\u4ef6\u53ea\u627e\u5230\u4e86 MySQL 5 \u7684\u6570\u636e\u5e93\u9a71\u52a8");
                    this.plugin.warn("\u8bf7\u4ece\u4ee5\u4e0b\u94fe\u63a5\u4e0b\u8f7d MySQL JDBC 8\uff0c\u653e\u5165 plugins/" + this.plugin.getDescription().getName() + "/libraries \u6587\u4ef6\u5939\uff0c\u5e76\u91cd\u542f\u670d\u52a1\u5668");
                    this.plugin.warn("https://mirrors.huaweicloud.com/repository/maven/com/mysql/mysql-connector-j/8.4.0/mysql-connector-j-8.4.0.jar");
                    break;
                }
                if (mysqlVersion != 5) break;
                this.plugin.warn("\u4f60\u5728\u6570\u636e\u5e93\u914d\u7f6e\u4e2d\u6307\u5b9a\u4e86 MySQL \u7248\u672c\u4e3a 5\uff0c\u4f46\u63d2\u4ef6\u672a\u627e\u5230\u76f8\u5e94\u7684\u6570\u636e\u5e93\u9a71\u52a8");
                this.plugin.warn("\u8bf7\u4ece\u4ee5\u4e0b\u94fe\u63a5\u4e0b\u8f7d MySQL JDBC 5\uff0c\u653e\u5165 plugins/" + this.plugin.getDescription().getName() + "/libraries \u6587\u4ef6\u5939\uff0c\u5e76\u91cd\u542f\u670d\u52a1\u5668");
                this.plugin.warn("https://mirrors.huaweicloud.com/repository/maven/mysql/mysql-connector-java/5.1.49/mysql-connector-java-5.1.49.jar");
                break;
            }
            default: {
                this.driver = this.checkDriver("SQLite", "org.sqlite.JDBC");
                if (this.driver != null) break;
                this.plugin.warn("\u8bf7\u4ece\u4ee5\u4e0b\u94fe\u63a5\u4e0b\u8f7d SQLite JDBC\uff0c\u653e\u5165 plugins/" + this.plugin.getDescription().getName() + "/libraries \u6587\u4ef6\u5939\uff0c\u5e76\u91cd\u542f\u670d\u52a1\u5668");
                this.plugin.warn("https://mirrors.huaweicloud.com/repository/maven/org/xerial/sqlite-jdbc/3.49.0.0/sqlite-jdbc-3.49.0.0.jar");
            }
        }
        if (this.driver == null) {
            return;
        }
        String query = config.getString("query", "");
        query = query.isEmpty() ? "" : "?" + query;
        this.hikariConfig = new HikariConfig();
        this.hikariConfig.setAutoCommit(true);
        this.hikariConfig.setMaxLifetime(config.getLong("hikari.max_lifetime", 120000L));
        this.hikariConfig.setConnectionTimeout(config.getLong("hikari.connection_timeout", 5000L));
        try {
            Class<?> clazz = this.hikariConfig.getClass();
            Field field = clazz.getDeclaredField("driverClassName");
            field.setAccessible(true);
            field.set(this.hikariConfig, this.driver);
        }
        catch (ReflectiveOperationException e) {
            this.plugin.warn("\u8bbe\u7f6e\u6570\u636e\u5e93\u9a71\u52a8\u65f6\u51fa\u73b0\u4e00\u4e2a\u5f02\u5e38", e);
            return;
        }
        if (type.equals("sqlite")) {
            this.hikariConfig.setMinimumIdle(1);
            this.hikariConfig.setMaximumPoolSize(1);
        } else {
            this.hikariConfig.setIdleTimeout(config.getLong("hikari.idle_timeout", 10000L));
            this.hikariConfig.setMinimumIdle(config.getInt("hikari.minimum_idle", 8));
            this.hikariConfig.setMaximumPoolSize(config.getInt("hikari.maximum_pool_size", 36));
        }
        if (this.isMySQL()) {
            String host = config.getString("mysql.host", "localhost");
            int port = config.getInt("mysql.port", 3306);
            String user = config.getString("mysql.user", "root");
            String pass = config.getString("mysql.pass", "root");
            String database = config.getString("mysql.database", "db");
            this.hikariConfig.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + query);
            this.hikariConfig.setUsername(user);
            this.hikariConfig.setPassword(pass);
            this.hikariConfig.setConnectionTestQuery("SELECT NOW();");
        }
        if (this.isSQLite()) {
            String database = config.getString("sqlite.file", "database.db");
            this.hikariConfig.setJdbcUrl("jdbc:sqlite:plugins/" + this.plugin.getName() + "/" + database);
            this.hikariConfig.setConnectionTestQuery("SELECT CURRENT_TIMESTAMP;");
        }
        if (!this.firstConnectFlag && !this.plugin.options.reconnectDatabaseWhenReloadConfig) {
            this.reconnect();
        }
    }

    private String checkDriver(String type, String driver) {
        if (!Util.isPresent(driver)) {
            this.plugin.warn("\u9884\u6599\u4e2d\u7684\u9519\u8bef: \u672a\u627e\u5230 " + type + " JDBC Driver: " + driver);
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return null;
        }
        return driver;
    }

    public void reconnect() {
        if (this.hikariConfig == null) {
            this.plugin.getLogger().warning("\u672a\u627e\u5230\u6570\u636e\u5e93\u914d\u7f6e\uff0c\u505c\u6b62\u8fde\u63a5");
            return;
        }
        this.firstConnectFlag = true;
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        this.dataSource = new HikariDataSource(this.hikariConfig);
        this.plugin.getLogger().info("\u6b63\u5728\u8fde\u63a5\u6570\u636e\u5e93...");
        this.version = "unknown";
        Connection conn = this.getConnection();
        if (conn == null) {
            this.plugin.getLogger().warning("\u65e0\u6cd5\u8fde\u63a5\u5230\u6570\u636e\u5e93!");
        } else {
            try (Connection connection = conn;){
                try (PreparedStatement ps = connection.prepareStatement(this.isSQLite() ? "SELECT SQLITE_VERSION();" : "SELECT VERSION();");
                     ResultSet result = ps.executeQuery();){
                    if (result.next()) {
                        this.version = result.getString(1);
                    }
                }
                catch (SQLException e) {
                    this.plugin.warn("\u83b7\u53d6\u76ee\u6807\u6570\u636e\u5e93\u7248\u672c\u65f6\u51fa\u73b0\u4e00\u4e2a\u9519\u8bef: " + e);
                }
                for (IDatabase db : this.databases) {
                    db.reload(connection, this.getTablePrefix());
                }
                this.plugin.getLogger().info("\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f");
            }
            catch (Throwable t) {
                this.plugin.warn("\u8fde\u63a5\u6570\u636e\u5e93\u65f6\u51fa\u73b0\u4e00\u4e2a\u9519\u8bef", t);
            }
        }
    }

    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

