/*
 * Decompiled with CFR 0.152.
 */
package top.mrxiaom.pluginbase;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import top.mrxiaom.pluginbase.BungeeIncomingChannel;
import top.mrxiaom.pluginbase.DatabaseHolder;
import top.mrxiaom.pluginbase.EconomyHolder;
import top.mrxiaom.pluginbase.actions.ActionActionBar;
import top.mrxiaom.pluginbase.actions.ActionClose;
import top.mrxiaom.pluginbase.actions.ActionConsole;
import top.mrxiaom.pluginbase.actions.ActionMessage;
import top.mrxiaom.pluginbase.actions.ActionMessageAdventure;
import top.mrxiaom.pluginbase.actions.ActionPlayer;
import top.mrxiaom.pluginbase.actions.ActionProviders;
import top.mrxiaom.pluginbase.api.IScheduler;
import top.mrxiaom.pluginbase.database.IDatabase;
import top.mrxiaom.pluginbase.func.AbstractPluginHolder;
import top.mrxiaom.pluginbase.func.AutoRegister;
import top.mrxiaom.pluginbase.func.GuiManager;
import top.mrxiaom.pluginbase.func.LanguageManager;
import top.mrxiaom.pluginbase.utils.ClassLoaderWrapper;
import top.mrxiaom.pluginbase.utils.Util;
import top.mrxiaom.pluginbase.utils.scheduler.BukkitScheduler;

public abstract class BukkitPlugin
extends JavaPlugin {
    private static final String className = BukkitPlugin.class.getName();
    private static BukkitPlugin instance;
    private final List<Class<? extends AbstractPluginHolder<?>>> modulesToRegister = new ArrayList();
    private boolean pluginEnabled = false;
    public final Options options;
    protected final ClassLoaderWrapper classLoader;
    protected IScheduler scheduler = new BukkitScheduler(this);

    protected static OptionsBuilder options() {
        return new OptionsBuilder();
    }

    public static BukkitPlugin getInstance() {
        return instance;
    }

    public BukkitPlugin(OptionsBuilder builder) {
        this(builder.build());
    }

    private BukkitPlugin(Options options) {
        if (className.equals("group.pluginbase.BukkitPlugin".replace("group", "top.mrxiaom"))) {
            throw new IllegalStateException("PluginBase \u4f9d\u8d56\u6ca1\u6709 relocate \u5230\u63d2\u4ef6\u5305\uff0c\u63d2\u4ef6\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005\u89e3\u51b3\u8be5\u95ee\u9898\n\u53c2\u8003\u6587\u6863: https://github.com/MrXiaoM/PluginBase");
        }
        instance = this;
        this.options = options;
        this.classLoader = new ClassLoaderWrapper((URLClassLoader)this.getClassLoader());
        if (this.options.libraries() || this.options.database) {
            this.loadLibraries();
        }
    }

    protected void loadLibraries() {
        File librariesFolder = new File(this.getDataFolder(), "libraries");
        if (!librariesFolder.exists()) {
            this.createLibrariesFolder(librariesFolder);
        }
        List<File> files = this.listLibraries(librariesFolder);
        for (File file : files) {
            if (file.isDirectory()) continue;
            try {
                URL url = file.toURI().toURL();
                this.classLoader.addURL(url);
                this.info("\u5df2\u52a0\u8f7d\u4f9d\u8d56\u5e93 " + file.getName());
                this.afterLoadLib(file);
            }
            catch (Throwable t) {
                this.warn("\u65e0\u6cd5\u52a0\u8f7d\u4f9d\u8d56\u5e93 " + file.getName(), t);
            }
        }
    }

    protected void createLibrariesFolder(File folder) {
        if (this.options.libraries()) {
            Util.mkdirs(folder);
        }
    }

    protected List<File> listLibraries(File folder) {
        File[] files;
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = files = folder.isDirectory() ? folder.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
                list.add(file);
            }
        }
        return list;
    }

    protected void afterLoadLib(File file) {
    }

    public IScheduler getScheduler() {
        return this.scheduler;
    }

    public Connection getConnection() {
        return this.options.databaseHolder == null ? null : this.options.databaseHolder.getConnection();
    }

    protected void beforeLoad() {
    }

    protected void afterLoad() {
    }

    protected void beforeEnable() {
    }

    protected void afterEnable() {
    }

    protected void beforeDisable() {
    }

    protected void afterDisable() {
    }

    @Deprecated
    public void onLoad() {
        this.beforeLoad();
        this.afterLoad();
    }

    private void earlyLoadModules() {
        ArrayList earlyLoadModules = new ArrayList();
        try {
            Class<LanguageManager> languageManagerClass = LanguageManager.class;
            earlyLoadModules.add(languageManagerClass);
        }
        catch (Throwable languageManagerClass) {
            // empty catch block
        }
        try {
            Class<GuiManager> guiManagerClass = GuiManager.class;
            earlyLoadModules.add(guiManagerClass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ActionProviders.registerActionProvider(ActionConsole.PROVIDER);
            ActionProviders.registerActionProvider(ActionPlayer.PROVIDER);
            if (this.options.adventure) {
                ActionProviders.registerActionProvider(ActionActionBar.PROVIDER);
                ActionProviders.registerActionProvider(ActionMessageAdventure.PROVIDER);
            } else {
                ActionProviders.registerActionProvider(ActionMessage.PROVIDER);
            }
            ActionProviders.registerActionProvider(ActionClose.PROVIDER);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        AbstractPluginHolder.loadModules(this, earlyLoadModules);
        earlyLoadModules.clear();
    }

    @Deprecated
    public void onEnable() {
        Util.init(this);
        this.options.enable(this);
        if (this.options.vaultEconomy && this.options.economyHolder != null) {
            this.options.economyHolder.load();
        }
        String packageName = this.options.scanPackage != null ? this.options.scanPackage : ((Object)((Object)this)).getClass().getPackage().getName();
        Set<Class<?>> classes = Util.getClasses(this.getClassLoader(), packageName, this.options.scanIgnore);
        for (Class<?> clazz : classes) {
            AutoRegister annotation;
            if (clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum() || !AbstractPluginHolder.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(AutoRegister.class)) == null) continue;
            this.modulesToRegister.add(clazz);
        }
        this.pluginEnabled = true;
        this.earlyLoadModules();
        this.beforeEnable();
        AbstractPluginHolder.loadModules(this, this.modulesToRegister);
        this.modulesToRegister.clear();
        this.reloadConfig();
        if (this.options.bungee) {
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)new BungeeIncomingChannel());
        }
        this.afterEnable();
    }

    @SafeVarargs
    protected final void registerModules(Class<? extends AbstractPluginHolder<?>> ... classList) {
        if (this.pluginEnabled) {
            AbstractPluginHolder.loadModules(this, Lists.newArrayList((Object[])classList));
        } else {
            this.modulesToRegister.addAll(Arrays.asList(classList));
        }
    }

    @Deprecated
    public void onDisable() {
        this.beforeDisable();
        AbstractPluginHolder.callDisable();
        if (this.options.bungee) {
            this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
            this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        }
        HandlerList.unregisterAll((Plugin)this);
        this.scheduler.cancelTasks();
        this.options.disable();
        this.pluginEnabled = false;
        this.afterDisable();
        ArrayList<Driver> toRemove = new ArrayList<Driver>();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getClassLoader().equals(this.getClassLoader())) continue;
            toRemove.add(driver);
        }
        for (Driver driver : toRemove) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException sQLException) {}
        }
        toRemove.clear();
    }

    protected void beforeReloadConfig(FileConfiguration config) {
    }

    private FileConfiguration resolveGotoFlag(FileConfiguration last, int times) {
        if (times > 64) {
            this.warn("\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684 goto \u8df3\u8f6c\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u81ea\u884c\u68c0\u67e5 goto \u6807\u7b7e\u662f\u5426\u6709\u5faa\u73af\u8c03\u7528\u95ee\u9898");
            return last;
        }
        String gotoFlag = last.getString("goto", null);
        if (gotoFlag != null) {
            File file = this.resolve(gotoFlag);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)file);
            return this.resolveGotoFlag((FileConfiguration)newConfig, times + 1);
        }
        return last;
    }

    public void reloadConfig() {
        YamlConfiguration config;
        if (!this.options.disableDefaultConfig) {
            this.saveDefaultConfig();
            super.reloadConfig();
            config = this.getConfig();
            if (this.options.enableConfigGotoFlag) {
                config = this.resolveGotoFlag((FileConfiguration)config, 0);
            }
        } else {
            config = new YamlConfiguration();
        }
        this.beforeReloadConfig((FileConfiguration)config);
        if (this.options.database && this.options.databaseHolder != null) {
            this.options.databaseHolder.reloadConfig();
            if (this.options.reconnectDatabaseWhenReloadConfig) {
                this.options.databaseHolder.reconnect();
            }
        }
        AbstractPluginHolder.reloadAllConfig((MemoryConfiguration)config);
    }

    public void info(String msg) {
        this.getLogger().log(Level.INFO, msg);
    }

    public void warn(String msg, Throwable t) {
        this.getLogger().log(Level.WARNING, msg, t);
    }

    public void warn(String msg) {
        this.getLogger().log(Level.WARNING, msg);
    }

    public void error(String msg, Throwable t) {
        this.getLogger().log(Level.SEVERE, msg, t);
    }

    public void error(String msg) {
        this.getLogger().log(Level.SEVERE, msg);
    }

    public void saveResource(String path) {
        this.saveResource(path, new File(this.getDataFolder(), path));
    }

    public void saveResource(String path, File file) {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            Util.mkdirs(parent);
        }
        try (InputStream resource = this.getResource(path);){
            if (resource == null) {
                return;
            }
            try (FileOutputStream output = new FileOutputStream(file);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = resource.read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            this.warn("\u4fdd\u5b58\u8d44\u6e90\u6587\u4ef6 " + path + " \u65f6\u51fa\u9519", e);
        }
    }

    public File resolve(String path) {
        return path.startsWith("./") ? new File(this.getDataFolder(), path.substring(2)) : new File(path);
    }

    public static class OptionsBuilder {
        protected boolean bungee;
        protected boolean database;
        protected boolean reconnectDatabaseWhenReloadConfig;
        protected boolean vaultEconomy;
        protected String scanPackage = null;
        protected List<String> scanIgnore = new ArrayList<String>();
        protected boolean adventure;
        protected boolean libraries;
        protected boolean disableDefaultConfig;
        protected boolean enableConfigGotoFlag;

        private Options build() {
            return new Options(){
                {
                    OptionsBuilder builder = this;
                    this.bungee = builder.bungee;
                    this.database = builder.database;
                    this.reconnectDatabaseWhenReloadConfig = builder.reconnectDatabaseWhenReloadConfig;
                    this.vaultEconomy = builder.vaultEconomy;
                    this.scanPackage = builder.scanPackage;
                    this.scanIgnore = builder.scanIgnore;
                    this.adventure = builder.adventure;
                    this.libraries = builder.libraries;
                    this.disableDefaultConfig = builder.disableDefaultConfig;
                    this.enableConfigGotoFlag = builder.enableConfigGotoFlag;
                }
            };
        }

        public OptionsBuilder bungee(boolean value) {
            this.bungee = value;
            return this;
        }

        public OptionsBuilder database(boolean value) {
            this.database = value;
            return this;
        }

        public OptionsBuilder reconnectDatabaseWhenReloadConfig(boolean value) {
            this.reconnectDatabaseWhenReloadConfig = value;
            return this;
        }

        public OptionsBuilder vaultEconomy(boolean value) {
            this.vaultEconomy = value;
            return this;
        }

        public OptionsBuilder scanPackage(String packageName) {
            this.scanPackage = packageName;
            return this;
        }

        public OptionsBuilder scanIgnore(Collection<String> packageNames) {
            this.scanIgnore.clear();
            this.scanIgnore.addAll(packageNames);
            return this;
        }

        public OptionsBuilder scanIgnore(String ... packageNames) {
            return this.scanIgnore(Lists.newArrayList((Object[])packageNames));
        }

        public OptionsBuilder adventure(boolean adventure) {
            this.adventure = adventure;
            return this;
        }

        public OptionsBuilder libraries(boolean libraries) {
            this.libraries = libraries;
            return this;
        }

        public OptionsBuilder disableDefaultConfig(boolean disableDefaultConfig) {
            this.disableDefaultConfig = disableDefaultConfig;
            return this;
        }

        public OptionsBuilder enableConfigGotoFlag(boolean enableConfigGotoFlag) {
            this.enableConfigGotoFlag = enableConfigGotoFlag;
            return this;
        }
    }

    public static class Options {
        protected boolean bungee;
        protected boolean database;
        protected boolean reconnectDatabaseWhenReloadConfig;
        protected boolean vaultEconomy;
        protected String scanPackage;
        protected List<String> scanIgnore;
        protected boolean adventure;
        protected boolean libraries;
        protected boolean disableDefaultConfig;
        protected boolean enableConfigGotoFlag;
        protected DatabaseHolder databaseHolder;
        protected EconomyHolder economyHolder;

        private Options() {
        }

        private void enable(BukkitPlugin plugin) {
            if (this.database) {
                this.databaseHolder = new DatabaseHolder(plugin);
            }
            if (this.vaultEconomy) {
                this.economyHolder = new EconomyHolder(plugin);
            }
        }

        private void disable() {
            if (this.database && this.databaseHolder != null) {
                this.databaseHolder.close();
            }
        }

        public void registerDatabase(IDatabase ... databases) {
            if (this.database && this.databaseHolder != null) {
                this.databaseHolder.registerDatabase(databases);
            }
        }

        public EconomyHolder economy() {
            return this.vaultEconomy ? this.economyHolder : null;
        }

        public DatabaseHolder database() {
            return this.database ? this.databaseHolder : null;
        }

        public boolean adventure() {
            return this.adventure;
        }

        public boolean libraries() {
            return this.libraries;
        }
    }
}

