/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AttributeValueListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbSnapshotAttributeRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbSnapshotAttributeRequest> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotIdentifier").getter(ModifyDbSnapshotAttributeRequest.getter(ModifyDbSnapshotAttributeRequest::dbSnapshotIdentifier)).setter(ModifyDbSnapshotAttributeRequest.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(ModifyDbSnapshotAttributeRequest.getter(ModifyDbSnapshotAttributeRequest::attributeName)).setter(ModifyDbSnapshotAttributeRequest.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<String>> VALUES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValuesToAdd").getter(ModifyDbSnapshotAttributeRequest.getter(ModifyDbSnapshotAttributeRequest::valuesToAdd)).setter(ModifyDbSnapshotAttributeRequest.setter(Builder::valuesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToAdd").build(), ListTrait.builder().memberLocationName("AttributeValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VALUES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValuesToRemove").getter(ModifyDbSnapshotAttributeRequest.getter(ModifyDbSnapshotAttributeRequest::valuesToRemove)).setter(ModifyDbSnapshotAttributeRequest.setter(Builder::valuesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValuesToRemove").build(), ListTrait.builder().memberLocationName("AttributeValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_TO_ADD_FIELD, VALUES_TO_REMOVE_FIELD));
    private final String dbSnapshotIdentifier;
    private final String attributeName;
    private final List<String> valuesToAdd;
    private final List<String> valuesToRemove;

    private ModifyDbSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.attributeName = builder.attributeName;
        this.valuesToAdd = builder.valuesToAdd;
        this.valuesToRemove = builder.valuesToRemove;
    }

    public final String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasValuesToAdd() {
        return this.valuesToAdd != null && !(this.valuesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> valuesToAdd() {
        return this.valuesToAdd;
    }

    public final boolean hasValuesToRemove() {
        return this.valuesToRemove != null && !(this.valuesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> valuesToRemove() {
        return this.valuesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValuesToAdd() ? this.valuesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValuesToRemove() ? this.valuesToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDbSnapshotAttributeRequest other = (ModifyDbSnapshotAttributeRequest)((Object)obj);
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.attributeName(), other.attributeName()) && this.hasValuesToAdd() == other.hasValuesToAdd() && Objects.equals(this.valuesToAdd(), other.valuesToAdd()) && this.hasValuesToRemove() == other.hasValuesToRemove() && Objects.equals(this.valuesToRemove(), other.valuesToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbSnapshotAttributeRequest").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("AttributeName", (Object)this.attributeName()).add("ValuesToAdd", this.hasValuesToAdd() ? this.valuesToAdd() : null).add("ValuesToRemove", this.hasValuesToRemove() ? this.valuesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "ValuesToAdd": {
                return Optional.ofNullable(clazz.cast(this.valuesToAdd()));
            }
            case "ValuesToRemove": {
                return Optional.ofNullable(clazz.cast(this.valuesToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSnapshotAttributeRequest, T> g) {
        return obj -> g.apply((ModifyDbSnapshotAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String attributeName;
        private List<String> valuesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> valuesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSnapshotAttributeRequest model) {
            super(model);
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.attributeName(model.attributeName);
            this.valuesToAdd(model.valuesToAdd);
            this.valuesToRemove(model.valuesToRemove);
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Collection<String> getValuesToAdd() {
            if (this.valuesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valuesToAdd;
        }

        public final void setValuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
        }

        @Override
        public final Builder valuesToAdd(Collection<String> valuesToAdd) {
            this.valuesToAdd = AttributeValueListCopier.copy(valuesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToAdd(String ... valuesToAdd) {
            this.valuesToAdd(Arrays.asList(valuesToAdd));
            return this;
        }

        public final Collection<String> getValuesToRemove() {
            if (this.valuesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valuesToRemove;
        }

        public final void setValuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
        }

        @Override
        public final Builder valuesToRemove(Collection<String> valuesToRemove) {
            this.valuesToRemove = AttributeValueListCopier.copy(valuesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesToRemove(String ... valuesToRemove) {
            this.valuesToRemove(Arrays.asList(valuesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbSnapshotAttributeRequest build() {
            return new ModifyDbSnapshotAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbSnapshotAttributeRequest> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder attributeName(String var1);

        public Builder valuesToAdd(Collection<String> var1);

        public Builder valuesToAdd(String ... var1);

        public Builder valuesToRemove(Collection<String> var1);

        public Builder valuesToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

