/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

class BaseSetExParams<T extends BaseSetExParams>
implements IParams {
    private Protocol.Keyword expiration;
    private Long expirationValue;

    BaseSetExParams() {
    }

    private T expiration(Protocol.Keyword type, Long value) {
        this.expiration = type;
        this.expirationValue = value;
        return (T)this;
    }

    public T ex(long remainingSeconds) {
        return this.expiration(Protocol.Keyword.EX, remainingSeconds);
    }

    public T px(long remainingMilliseconds) {
        return this.expiration(Protocol.Keyword.PX, remainingMilliseconds);
    }

    public T exAt(long timestampSeconds) {
        return this.expiration(Protocol.Keyword.EXAT, timestampSeconds);
    }

    public T pxAt(long timestampMilliseconds) {
        return this.expiration(Protocol.Keyword.PXAT, timestampMilliseconds);
    }

    @Deprecated
    public T keepttl() {
        return this.keepTtl();
    }

    public T keepTtl() {
        return this.expiration(Protocol.Keyword.KEEPTTL, null);
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.expiration != null) {
            args.add(this.expiration);
            if (this.expirationValue != null) {
                args.add(this.expirationValue);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseSetExParams setParams = (BaseSetExParams)o;
        return Objects.equals(this.expiration, setParams.expiration) && Objects.equals(this.expirationValue, setParams.expirationValue);
    }

    public int hashCode() {
        return Objects.hash(this.expiration, this.expirationValue);
    }
}

