/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.processor;

import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring5.context.IThymeleafBindStatus;
import org.thymeleaf.spring5.util.FieldUtils;
import org.thymeleaf.spring5.util.SpringValueFormatter;
import org.thymeleaf.templatemode.TemplateMode;

public final class SpringUErrorsTagProcessor
extends AbstractAttributeTagProcessor {
    private static final String ERROR_DELIMITER = "<br />";
    public static final int ATTR_PRECEDENCE = 1200;
    public static final String ATTR_NAME = "uerrors";

    public SpringUErrorsTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 1200, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        IThymeleafBindStatus bindStatus = FieldUtils.getBindStatus((IExpressionContext)context, attributeValue);
        if (bindStatus.isError()) {
            StringBuilder strBuilder = new StringBuilder();
            String[] errorMsgs = bindStatus.getErrorMessages();
            for (int i = 0; i < errorMsgs.length; ++i) {
                if (i > 0) {
                    strBuilder.append(ERROR_DELIMITER);
                }
                String displayString = SpringValueFormatter.getDisplayString(errorMsgs[i], false);
                strBuilder.append(displayString);
            }
            structureHandler.setBody((CharSequence)strBuilder.toString(), false);
            structureHandler.setLocalVariable("thymeleafFieldBindStatus", (Object)bindStatus);
        } else {
            structureHandler.removeElement();
        }
    }
}

