/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.util.CommonUtils;

public class NetworkUtils {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);

    public static String getLocalHostName() {
        try {
            return InetAddress.getByName(NetworkUtils.getLocalIpAddress()).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)e);
            CommonUtils.runtimeException(e);
            return null;
        }
    }

    public static String getLocalIpAddress() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            System.out.println("address " + address.toString() + " " + address.isLoopbackAddress() + " " + address.getHostAddress() + " " + address.getHostName());
            if (address.isLoopbackAddress()) {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface ni = networkInterfaces.nextElement();
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        address = addresses.nextElement();
                        if (address.isLinkLocalAddress() || address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                        return address.getHostAddress();
                    }
                }
                LOG.warn((Object)("Your hostname, " + InetAddress.getLocalHost().getHostName() + " resolves to" + " a loopback address: " + address.getHostAddress() + ", but we couldn't find any" + " external IP address!"));
            }
            return address.getHostAddress();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            CommonUtils.runtimeException(e);
            return null;
        }
    }

    public static String replaceHostName(String addr) throws UnknownHostException {
        if (addr == null || addr.isEmpty()) {
            return null;
        }
        if (addr.contains("://")) {
            int idx = addr.indexOf("://");
            String prefix = addr.substring(0, idx + 3);
            String rest = addr.substring(idx + 3);
            if (rest.contains(":")) {
                int idx2 = rest.indexOf(":");
                String hostname = rest.substring(0, idx2);
                hostname = NetworkUtils.resolveHostName(hostname);
                String suffix = rest.substring(idx2);
                return prefix + hostname + suffix;
            }
            if (rest.contains("/")) {
                int idx2 = rest.indexOf("/");
                if (idx2 > 0) {
                    String hostname = rest.substring(0, idx2);
                    hostname = NetworkUtils.resolveHostName(hostname);
                    String suffix = rest.substring(idx2);
                    return prefix + hostname + suffix;
                }
            } else {
                return prefix + NetworkUtils.resolveHostName(rest);
            }
        }
        return addr;
    }

    public static String resolveHostName(String hostname) throws UnknownHostException {
        if (hostname == null || hostname.isEmpty()) {
            return null;
        }
        return InetAddress.getByName(hostname).getCanonicalHostName();
    }
}

