/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.Inode;
import tachyon.master.InodeFile;
import tachyon.thrift.ClientFileInfo;

public class InodeFolder
extends Inode {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private Set<Inode> mChildren = new HashSet<Inode>();

    static InodeFolder loadImage(JsonParser parser, ImageElement ele) throws IOException {
        long creationTimeMs = ele.getLong("creationTimeMs");
        int fileId = ele.getInt("id");
        String fileName = ele.getString("name");
        int parentId = ele.getInt("parentId");
        boolean isPinned = ele.getBoolean("pinned");
        List childrenIds = (List)ele.get("childrenIds");
        int numberOfChildren = childrenIds.size();
        Inode[] children = new Inode[numberOfChildren];
        block6: for (int k = 0; k < numberOfChildren; ++k) {
            ele = (ImageElement)parser.readValueAs(ImageElement.class);
            LOG.debug((Object)("Read Element: " + ele));
            switch (ele.type) {
                case InodeFile: {
                    children[k] = InodeFile.loadImage(ele);
                    continue block6;
                }
                case InodeFolder: {
                    children[k] = InodeFolder.loadImage(parser, ele);
                    continue block6;
                }
                default: {
                    throw new IOException("Invalid element type " + ele);
                }
            }
        }
        InodeFolder folder = new InodeFolder(fileName, fileId, parentId, creationTimeMs);
        folder.setPinned(isPinned);
        folder.addChildren(children);
        return folder;
    }

    public InodeFolder(String name, int id, int parentId, long creationTimeMs) {
        super(name, id, parentId, true, creationTimeMs);
    }

    public synchronized void addChild(Inode child) {
        this.mChildren.add(child);
    }

    public synchronized void addChildren(Inode[] children) {
        for (Inode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public ClientFileInfo generateClientFileInfo(String path) {
        ClientFileInfo ret = new ClientFileInfo();
        ret.id = this.getId();
        ret.name = this.getName();
        ret.path = path;
        ret.ufsPath = "";
        ret.length = 0L;
        ret.blockSizeByte = 0L;
        ret.creationTimeMs = this.getCreationTimeMs();
        ret.isComplete = true;
        ret.isFolder = true;
        ret.isPinned = this.isPinned();
        ret.isCache = false;
        ret.blockIds = null;
        ret.dependencyId = -1;
        return ret;
    }

    public synchronized Inode getChild(int fid) {
        for (Inode child : this.mChildren) {
            if (child.getId() != fid) continue;
            return child;
        }
        return null;
    }

    public synchronized Inode getChild(String name) {
        for (Inode child : this.mChildren) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public synchronized Set<Inode> getChildren() {
        return Collections.unmodifiableSet(this.mChildren);
    }

    public synchronized List<Integer> getChildrenIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.mChildren.size());
        for (Inode child : this.mChildren) {
            ret.add(child.getId());
        }
        return ret;
    }

    public synchronized int getNumberOfChildren() {
        return this.mChildren.size();
    }

    public synchronized boolean removeChild(Inode child) {
        return this.mChildren.remove(child);
    }

    public synchronized boolean removeChild(String name) {
        for (Inode child : this.mChildren) {
            if (!child.getName().equals(name)) continue;
            this.mChildren.remove(child);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("InodeFolder(");
        sb.append(super.toString()).append(",").append(this.mChildren).append(")");
        return sb.toString();
    }

    @Override
    public void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ImageElement ele = new ImageElement(ImageElementType.InodeFolder).withParameter("creationTimeMs", this.getCreationTimeMs()).withParameter("id", this.getId()).withParameter("name", this.getName()).withParameter("parentId", this.getParentId()).withParameter("pinned", this.isPinned()).withParameter("childrenIds", this.getChildrenIds());
        this.writeElement(objWriter, dos, ele);
        for (Inode inode : this.getChildren()) {
            inode.writeImage(objWriter, dos);
        }
    }
}

