/*
 * Decompiled with CFR 0.152.
 */
package tachyon.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import tachyon.client.InStream;
import tachyon.client.OutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.command.Utils;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.util.CommonUtils;

public class TFsShell {
    public static void main(String[] argv) throws TException {
        TFsShell shell = new TFsShell();
        System.exit(shell.run(argv));
    }

    public int cat(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs cat <path>");
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        TachyonFile tFile = tachyonClient.getFile(file);
        if (tFile == null) {
            System.out.println(file + " does not exist.");
            return -1;
        }
        if (tFile.isFile()) {
            InStream is = tFile.getInStream(ReadType.NO_CACHE);
            byte[] buf = new byte[512];
            int read = is.read(buf);
            while (read != -1) {
                System.out.write(buf, 0, read);
                read = is.read(buf);
            }
            return 0;
        }
        System.out.println(file + " is not a file.");
        return -1;
    }

    public int copyFromLocal(String[] argv) throws IOException {
        String file;
        if (argv.length != 3) {
            System.out.println("Usage: tfs copyFromLocal <src> <remoteDst>");
            return -1;
        }
        String srcPath = argv[1];
        String dstPath = argv[2];
        File src = new File(srcPath);
        if (!src.exists()) {
            System.out.println("Local path " + srcPath + " does not exist.");
            return -1;
        }
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(dstPath));
        int ret = this.copyPath(src, tachyonClient, file = Utils.getFilePath(dstPath));
        if (ret == 0) {
            System.out.println("Copied " + src.getPath() + " to " + dstPath);
        }
        return ret;
    }

    private int copyPath(File src, TachyonFS tachyonClient, String dstPath) throws IOException {
        if (!src.isDirectory()) {
            int fileId = tachyonClient.createFile(dstPath);
            if (fileId == -1) {
                return -1;
            }
            TachyonFile tFile = tachyonClient.getFile(fileId);
            OutStream os = tFile.getOutStream(WriteType.CACHE_THROUGH);
            FileInputStream in = new FileInputStream(src);
            FileChannel channel = in.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(1024);
            while (channel.read(buf) != -1) {
                buf.flip();
                os.write(buf.array(), 0, buf.limit());
            }
            os.close();
            channel.close();
            in.close();
            return 0;
        }
        tachyonClient.mkdir(dstPath);
        for (String file : src.list()) {
            File srcFile = new File(src, file);
            String newPath = FilenameUtils.concat((String)dstPath, (String)file);
            if (this.copyPath(srcFile, tachyonClient, newPath) != -1) continue;
            return -1;
        }
        return 0;
    }

    public int copyToLocal(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("Usage: tfs copyToLocal <src> <localdst>");
            return -1;
        }
        String srcPath = argv[1];
        String dstPath = argv[2];
        String folder = Utils.getFilePath(srcPath);
        File dst = new File(dstPath);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(srcPath));
        TachyonFile tFile = tachyonClient.getFile(folder);
        if (tFile == null) {
            throw new IOException(folder);
        }
        InStream is = tFile.getInStream(ReadType.NO_CACHE);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[512];
        int t = is.read(buf);
        while (t != -1) {
            out.write(buf, 0, t);
            t = is.read(buf);
        }
        out.close();
        System.out.println("Copied " + srcPath + " to " + dstPath);
        return 0;
    }

    public int count(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs count <path>");
            return -1;
        }
        String path = argv[1];
        long[] values = this.countHelper(path);
        String format = "%-25s%-25s%-15s\n";
        System.out.format(format, "File Count", "Folder Count", "Total Bytes");
        System.out.format(format, values[0], values[1], values[2]);
        return 0;
    }

    private long[] countHelper(String path) throws IOException {
        String folder;
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        TachyonFile tFile = tachyonClient.getFile(folder = Utils.getFilePath(path));
        if (tFile.isFile()) {
            return new long[]{1L, 0L, tFile.length()};
        }
        long[] rtn = new long[]{0L, 1L, 0L};
        List<ClientFileInfo> files = tachyonClient.listStatus(folder);
        Collections.sort(files);
        for (ClientFileInfo file : files) {
            long[] toAdd = this.countHelper(file.getPath());
            rtn[0] = rtn[0] + toAdd[0];
            rtn[1] = rtn[1] + toAdd[1];
            rtn[2] = rtn[2] + toAdd[2];
        }
        return rtn;
    }

    public int fileinfo(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs fileinfo <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        int fileId = tachyonClient.getFileId(file);
        List<ClientBlockInfo> blocks = tachyonClient.getFileBlocks(fileId);
        System.out.println(file + " with file id " + fileId + " have following blocks: ");
        for (ClientBlockInfo block : blocks) {
            System.out.println(block);
        }
        return 0;
    }

    public int location(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs location <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        int fileId = tachyonClient.getFileId(file);
        List<String> hosts = tachyonClient.getFile(fileId).getLocationHosts();
        System.out.println(file + " with file id " + fileId + " are on nodes: ");
        for (String host : hosts) {
            System.out.println(host);
        }
        return 0;
    }

    public int ls(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs ls <path>");
            return -1;
        }
        String path = argv[1];
        String folder = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        List<ClientFileInfo> files = tachyonClient.listStatus(folder);
        Collections.sort(files);
        String format = "%-10s%-25s%-15s%-5s\n";
        for (ClientFileInfo file : files) {
            String inMemory = "";
            if (!file.isFolder) {
                inMemory = 100 == file.inMemoryPercentage ? "In Memory" : "Not In Memory";
            }
            System.out.format(format, CommonUtils.getSizeFromBytes(file.getLength()), CommonUtils.convertMsToDate(file.getCreationTimeMs()), inMemory, file.getPath());
        }
        return 0;
    }

    public int lsr(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs lsr <path>");
            return -1;
        }
        String path = argv[1];
        String folder = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        List<ClientFileInfo> files = tachyonClient.listStatus(folder);
        Collections.sort(files);
        String format = "%-10s%-25s%-15s%-5s\n";
        for (ClientFileInfo file : files) {
            String inMemory = "";
            if (!file.isFolder) {
                inMemory = 100 == file.inMemoryPercentage ? "In Memory" : "Not In Memory";
            }
            System.out.format(format, CommonUtils.getSizeFromBytes(file.getLength()), CommonUtils.convertMsToDate(file.getCreationTimeMs()), inMemory, file.getPath());
            if (!file.isFolder) continue;
            this.lsr(new String[]{"lsr", file.getPath()});
        }
        return 0;
    }

    public int mkdir(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs mkdir <path>");
            return -1;
        }
        String path = argv[1];
        String folder = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        if (tachyonClient.mkdir(folder)) {
            System.out.println("Successfully created directory " + folder);
            return 0;
        }
        return -1;
    }

    public int pin(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs pin <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        int fileId = tachyonClient.getFileId(file);
        tachyonClient.pinFile(fileId);
        try {
            tachyonClient.pinFile(fileId);
            System.out.println("File '" + file + "' was successfully pinned.");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File '" + file + "' could not be pinned.");
            return -1;
        }
    }

    public int unpin(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs unpin <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        int fileId = tachyonClient.getFileId(file);
        try {
            tachyonClient.unpinFile(fileId);
            System.out.println("File '" + file + "' was successfully unpinned.");
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("File '" + file + "' could not be unpinned.");
            return -1;
        }
    }

    public void printUsage() {
        System.out.println("Usage: java TFsShell");
        System.out.println("       [cat <path>]");
        System.out.println("       [count <path>]");
        System.out.println("       [ls <path>]");
        System.out.println("       [lsr <path>]");
        System.out.println("       [mkdir <path>]");
        System.out.println("       [rm <path>]");
        System.out.println("       [tail <path>]");
        System.out.println("       [touch <path>]");
        System.out.println("       [mv <src> <dst>]");
        System.out.println("       [copyFromLocal <src> <remoteDst>]");
        System.out.println("       [copyToLocal <src> <localDst>]");
        System.out.println("       [fileinfo <path>]");
        System.out.println("       [location <path>]");
        System.out.println("       [report <path>]");
        System.out.println("       [request <tachyonaddress> <dependencyId>]");
        System.out.println("       [pin <path>]");
        System.out.println("       [unpin <path>]");
    }

    public int rename(String[] argv) throws IOException {
        String dstMasterAddr;
        if (argv.length != 3) {
            System.out.println("Usage: tfs mv <src> <dst>");
            return -1;
        }
        String srcPath = argv[1];
        String dstPath = argv[2];
        String srcMasterAddr = Utils.validatePath(srcPath);
        if (!srcMasterAddr.startsWith((dstMasterAddr = Utils.validatePath(dstPath)).substring(0, "tachyon://".length()))) {
            throw new IOException("The file system of source and destination must be the same");
        }
        String srcFile = Utils.getFilePath(srcPath);
        String dstFile = Utils.getFilePath(dstPath);
        TachyonFS tachyonClient = TachyonFS.get(srcMasterAddr);
        if (tachyonClient.rename(srcFile, dstFile)) {
            System.out.println("Renamed " + srcFile + " to " + dstFile);
            return 0;
        }
        return -1;
    }

    public int report(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs report <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        int fileId = tachyonClient.getFileId(file);
        tachyonClient.reportLostFile(fileId);
        System.out.println(file + " with file id " + fileId + " has reported been report lost.");
        return 0;
    }

    public int request(String[] argv) throws IOException {
        if (argv.length != 3) {
            System.out.println("Usage: tfs request <tachyonaddress> <dependencyId>");
            return -1;
        }
        String path = argv[1];
        int depId = Integer.parseInt(argv[2]);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        tachyonClient.requestFilesInDependency(depId);
        System.out.println("Dependency with ID " + depId + " has been requested.");
        return 0;
    }

    public int rm(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs rm <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        if (tachyonClient.delete(file, true)) {
            System.out.println(file + " has been removed");
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] argv) throws TException {
        int exitCode;
        block22: {
            if (argv.length == 0) {
                this.printUsage();
                return -1;
            }
            String cmd = argv[0];
            exitCode = -1;
            try {
                if (cmd.equals("cat")) {
                    exitCode = this.cat(argv);
                    break block22;
                }
                if (cmd.equals("count")) {
                    exitCode = this.count(argv);
                    break block22;
                }
                if (cmd.equals("ls")) {
                    exitCode = this.ls(argv);
                    break block22;
                }
                if (cmd.equals("lsr")) {
                    exitCode = this.lsr(argv);
                    break block22;
                }
                if (cmd.equals("mkdir")) {
                    exitCode = this.mkdir(argv);
                    break block22;
                }
                if (cmd.equals("rm")) {
                    exitCode = this.rm(argv);
                    break block22;
                }
                if (cmd.equals("tail")) {
                    exitCode = this.tail(argv);
                    break block22;
                }
                if (cmd.equals("mv")) {
                    exitCode = this.rename(argv);
                    break block22;
                }
                if (cmd.equals("touch")) {
                    exitCode = this.touch(argv);
                    break block22;
                }
                if (cmd.equals("copyFromLocal")) {
                    exitCode = this.copyFromLocal(argv);
                    break block22;
                }
                if (cmd.equals("copyToLocal")) {
                    exitCode = this.copyToLocal(argv);
                    break block22;
                }
                if (cmd.equals("fileinfo")) {
                    exitCode = this.fileinfo(argv);
                    break block22;
                }
                if (cmd.equals("location")) {
                    exitCode = this.location(argv);
                    break block22;
                }
                if (cmd.equals("report")) {
                    exitCode = this.report(argv);
                    break block22;
                }
                if (cmd.equals("request")) {
                    exitCode = this.request(argv);
                    break block22;
                }
                if (cmd.equals("pin")) {
                    exitCode = this.pin(argv);
                    break block22;
                }
                if (cmd.equals("unpin")) {
                    exitCode = this.unpin(argv);
                    break block22;
                }
                this.printUsage();
                int n = -1;
                return n;
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
        return exitCode;
    }

    public int tail(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs tail <path>");
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        TachyonFile tFile = tachyonClient.getFile(file);
        if (tFile == null) {
            System.out.println(file + " does not exist.");
            return -1;
        }
        if (tFile.isFile()) {
            InStream is = tFile.getInStream(ReadType.NO_CACHE);
            byte[] buf = new byte[1024];
            long bytesToRead = 0L;
            bytesToRead = tFile.length() > 1024L ? 1024L : tFile.length();
            is.skip(tFile.length() - bytesToRead);
            int read = is.read(buf);
            System.out.write(buf, 0, read);
            return 0;
        }
        System.out.println(file + " is not a file.");
        return -1;
    }

    public int touch(String[] argv) throws IOException {
        if (argv.length != 2) {
            System.out.println("Usage: tfs touch <path>");
            return -1;
        }
        String path = argv[1];
        String file = Utils.getFilePath(path);
        TachyonFS tachyonClient = TachyonFS.get(Utils.validatePath(path));
        TachyonFile tFile = tachyonClient.getFile(tachyonClient.createFile(file));
        OutStream out = tFile.getOutStream(WriteType.THROUGH);
        ((OutputStream)out).close();
        System.out.println(path + " has been created");
        return 0;
    }
}

