/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.util.HashMap;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import tachyon.Constants;
import tachyon.util.CommonUtils;

public class LeaderInquireClient {
    private static final int MAX_TRY = 10;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final String ZOOKEEPER_ADDRESS;
    private final String LEADER_PATH;
    private final CuratorFramework CLIENT;
    private static HashMap<String, LeaderInquireClient> createdClients = new HashMap();

    public static synchronized LeaderInquireClient getClient(String zookeeperAddress, String leaderPath) {
        String key = zookeeperAddress + leaderPath;
        if (!createdClients.containsKey(key)) {
            createdClients.put(key, new LeaderInquireClient(zookeeperAddress, leaderPath));
        }
        return createdClients.get(key);
    }

    private LeaderInquireClient(String zookeeperAddress, String leaderPath) {
        this.ZOOKEEPER_ADDRESS = zookeeperAddress;
        this.LEADER_PATH = leaderPath;
        this.CLIENT = CuratorFrameworkFactory.newClient((String)this.ZOOKEEPER_ADDRESS, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.CLIENT.start();
    }

    public synchronized String getMasterAddress() {
        int tried = 0;
        try {
            while (tried < 10) {
                if (this.CLIENT.checkExists().forPath(this.LEADER_PATH) != null) {
                    List masters = (List)this.CLIENT.getChildren().forPath(this.LEADER_PATH);
                    this.LOG.info((Object)masters);
                    if (masters.size() >= 1) {
                        if (masters.size() == 1) {
                            return (String)masters.get(0);
                        }
                        long maxTime = 0L;
                        String leader = "";
                        for (String master : masters) {
                            Stat stat = (Stat)this.CLIENT.checkExists().forPath(CommonUtils.concat(this.LEADER_PATH, master));
                            if (stat == null || stat.getCtime() <= maxTime) continue;
                            maxTime = stat.getCtime();
                            leader = master;
                        }
                        return leader;
                    }
                } else {
                    this.LOG.info((Object)(this.LEADER_PATH + " does not exist (" + ++tried + ")"));
                }
                CommonUtils.sleepMs(this.LOG, 1000L);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

