/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block.spawner;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="SpawnRule")
public class SpawnRule
implements Cloneable,
ConfigurationSerializable {
    private int minBlockLight;
    private int maxBlockLight;
    private int minSkyLight;
    private int maxSkyLight;

    public SpawnRule(int minBlockLight, int maxBlockLight, int minSkyLight, int maxSkyLight) {
        Preconditions.checkArgument((minBlockLight <= maxBlockLight ? 1 : 0) != 0, (String)"minBlockLight must be <= maxBlockLight (%s <= %s)", (int)minBlockLight, (int)maxBlockLight);
        Preconditions.checkArgument((minSkyLight <= maxSkyLight ? 1 : 0) != 0, (String)"minSkyLight must be <= maxSkyLight (%s <= %s)", (int)minSkyLight, (int)maxSkyLight);
        Preconditions.checkArgument((minBlockLight >= 0 ? 1 : 0) != 0, (String)"minBlockLight must be >= 0 (given %s)", (int)minBlockLight);
        Preconditions.checkArgument((maxBlockLight >= 0 ? 1 : 0) != 0, (String)"maxBlockLight must be >= 0 (given %s)", (int)maxBlockLight);
        Preconditions.checkArgument((minSkyLight >= 0 ? 1 : 0) != 0, (String)"minSkyLight must be >= 0 (given %s)", (int)minSkyLight);
        Preconditions.checkArgument((maxSkyLight >= 0 ? 1 : 0) != 0, (String)"maxSkyLight must be >= 0 (given %s)", (int)maxSkyLight);
        this.minBlockLight = minBlockLight;
        this.maxBlockLight = maxBlockLight;
        this.minSkyLight = minSkyLight;
        this.maxSkyLight = maxSkyLight;
    }

    public int getMinBlockLight() {
        return this.minBlockLight;
    }

    public void setMinBlockLight(int minBlockLight) {
        Preconditions.checkArgument((minBlockLight >= 0 ? 1 : 0) != 0, (String)"minBlockLight must be >= 0 (given %s)", (int)minBlockLight);
        Preconditions.checkArgument((minBlockLight <= this.maxBlockLight ? 1 : 0) != 0, (String)"minBlockLight must be <= maxBlockLight (%s <= %s)", (int)minBlockLight, (int)this.maxBlockLight);
        this.minBlockLight = minBlockLight;
    }

    public int getMaxBlockLight() {
        return this.maxBlockLight;
    }

    public void setMaxBlockLight(int maxBlockLight) {
        Preconditions.checkArgument((maxBlockLight >= 0 ? 1 : 0) != 0, (String)"maxBlockLight must be >= 0 (given %s)", (int)maxBlockLight);
        this.maxBlockLight = maxBlockLight;
    }

    public int getMinSkyLight() {
        return this.minSkyLight;
    }

    public void setMinSkyLight(int minSkyLight) {
        Preconditions.checkArgument((minSkyLight >= 0 ? 1 : 0) != 0, (String)"minSkyLight must be >= 0 (given %s)", (int)minSkyLight);
        Preconditions.checkArgument((minSkyLight <= this.maxSkyLight ? 1 : 0) != 0, (String)"minSkyLight must be <= maxSkyLight (%s <= %s)", (int)minSkyLight, (int)this.maxSkyLight);
        this.minSkyLight = minSkyLight;
    }

    public int getMaxSkyLight() {
        return this.maxSkyLight;
    }

    public void setMaxSkyLight(int maxSkyLight) {
        Preconditions.checkArgument((maxSkyLight >= 0 ? 1 : 0) != 0, (String)"maxSkyLight must be >= 0 (given %s)", (int)maxSkyLight);
        this.maxSkyLight = maxSkyLight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpawnRule)) {
            return false;
        }
        SpawnRule other = (SpawnRule)obj;
        return this.minBlockLight == other.minBlockLight && this.maxBlockLight == other.maxBlockLight && this.minSkyLight == other.minSkyLight && this.maxSkyLight == other.maxSkyLight;
    }

    public int hashCode() {
        int hash = this.minBlockLight;
        hash = (hash << 4) + this.maxBlockLight;
        hash = (hash << 4) + this.minSkyLight;
        hash = (hash << 4) + this.maxSkyLight;
        return hash;
    }

    @NotNull
    public SpawnRule clone() {
        try {
            return (SpawnRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Integer> block = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> sky = new LinkedHashMap<String, Integer>();
        block.put("min", this.getMinBlockLight());
        block.put("max", this.getMaxBlockLight());
        sky.put("min", this.getMinSkyLight());
        sky.put("max", this.getMaxSkyLight());
        result.put("block-light", block);
        result.put("sky-light", sky);
        return result;
    }

    @NotNull
    public static SpawnRule deserialize(@NotNull Map<String, Object> args) {
        int minBlock = 0;
        int maxBlock = 0;
        int minSky = 0;
        int maxSky = 0;
        Object block = args.get("block-light");
        Object sky = args.get("sky-light");
        if (block instanceof Map) {
            Map blockMap = (Map)block;
            if (blockMap.containsKey("min")) {
                minBlock = (Integer)blockMap.get("min");
            }
            if (blockMap.containsKey("max")) {
                maxBlock = (Integer)blockMap.get("max");
            }
        }
        if (sky instanceof Map) {
            Map skyMap = (Map)sky;
            if (skyMap.containsKey("min")) {
                minSky = (Integer)skyMap.get("min");
            }
            if (skyMap.containsKey("max")) {
                maxSky = (Integer)skyMap.get("max");
            }
        }
        return new SpawnRule(minBlock, maxBlock, minSky, maxSky);
    }
}

