/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import com.google.common.base.Preconditions;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class EntityKnockbackEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final KnockbackCause cause;
    private final double force;
    private final Vector rawKnockback;
    private Vector knockback;
    private boolean cancelled;

    public EntityKnockbackEvent(@NotNull LivingEntity entity, @NotNull KnockbackCause cause, double force, @NotNull Vector rawKnockback, @NotNull Vector knockback) {
        super(entity);
        this.cause = cause;
        this.force = force;
        this.rawKnockback = rawKnockback;
        this.knockback = knockback;
    }

    @Override
    @NotNull
    public LivingEntity getEntity() {
        return (LivingEntity)this.entity;
    }

    @NotNull
    public KnockbackCause getCause() {
        return this.cause;
    }

    public double getForce() {
        return this.force;
    }

    @NotNull
    public Vector getKnockback() {
        return this.rawKnockback.clone();
    }

    @NotNull
    public Vector getFinalKnockback() {
        return this.knockback.clone();
    }

    @NotNull
    public void setFinalKnockback(@NotNull Vector knockback) {
        Preconditions.checkArgument((knockback != null ? 1 : 0) != 0, (Object)"Knockback cannot be null");
        this.knockback = knockback;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum KnockbackCause {
        DAMAGE,
        ENTITY_ATTACK,
        EXPLOSION,
        SHIELD_BLOCK,
        SWEEP_ATTACK,
        UNKNOWN;

    }
}

