package org.bukkit.entity;

/**
 * Represents an entity body pose.
 */
public enum Pose {

    /**
     * Entity is standing normally.
     *
     */
    STANDING,
    /**
     * Entity is gliding.
     */
    FALL_FLYING,
    /**
     * Entity is sleeping.
     */
    SLEEPING,
    /**
     * Entity is swimming.
     */
    SWIMMING,
    /**
     * Entity is riptiding with a trident.
     */
    SPIN_ATTACK,
    /**
     * Entity is sneaking.
     */
    SNEAKING,
    /**
     * Entity is long jumping.
     */
    LONG_JUMPING,
    /**
     * Entity is dead.
     */
    DYING,
    /**
     * Entity is croaking.
     */
    CROAKING,
    /**
     * Entity is using its tongue.
     */
    USING_TONGUE,
    /**
     * Entity is sitting.
     */
    SITTING,
    /**
     * Entity is roaring.
     */
    ROARING,
    /**
     * Entity is sniffing.
     */
    SNIFFING,
    /**
     * Entity is emerging.
     */
    EMERGING,
    /**
     * Entity is digging.
     */
    DIGGING,
    /**
     * Entity is sliding.
     */
    SLIDING,
    /**
     * Entity is shooting.
     */
    SHOOTING,
    /**
     * Entity is inhaling.
     */
    INHALING;
}
