/*
 * Decompiled with CFR 0.152.
 */
package org.pacesys.reflect.types;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.pacesys.reflect.types.Predicate;

public class Predicates {
    @SafeVarargs
    public static <T extends AccessibleObject> Predicate<T> findByAnnotations(Class<? extends Annotation> ... annotations) {
        return new AnnotatedPredicate(annotations);
    }

    public static <T extends AccessibleObject> Predicate<T> findByAnnotations(Set<Class<? extends Annotation>> annotations) {
        return new AnnotatedPredicate(annotations);
    }

    public static <T extends Member> Predicate<T> publicAccess() {
        return new PublicAccessPredicate();
    }

    public static Predicate<Field> fieldName(String search) {
        return new MemberByNamePredicate<Field>(search);
    }

    public static Predicate<Method> methodName(String search) {
        return new MemberByNamePredicate<Method>(search);
    }

    static class AnnotatedPredicate<T extends AccessibleObject>
    implements Predicate<T> {
        Set<Class<? extends Annotation>> annotations;

        @SafeVarargs
        AnnotatedPredicate(Class<? extends Annotation> ... annotations) {
            this.annotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(annotations));
        }

        AnnotatedPredicate(Set<Class<? extends Annotation>> annotations) {
            this.annotations = annotations;
        }

        @Override
        public boolean apply(T input) {
            for (Annotation a : ((AccessibleObject)input).getAnnotations()) {
                if (!this.annotations.contains(a.annotationType())) continue;
                return true;
            }
            return false;
        }
    }

    static class PublicAccessPredicate<T extends Member>
    implements Predicate<T> {
        PublicAccessPredicate() {
        }

        @Override
        public boolean apply(T input) {
            return Modifier.isPublic(input.getModifiers());
        }
    }

    static class MemberByNamePredicate<T extends Member>
    implements Predicate<T> {
        String search;

        MemberByNamePredicate(String search) {
            this.search = search;
        }

        @Override
        public boolean apply(T input) {
            return input.getName().equalsIgnoreCase(this.search);
        }
    }
}

