/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public abstract class RenameToCamelCase
extends JavaIsoVisitor<ExecutionContext> {
    @Nullable
    public J postVisit(J tree, ExecutionContext ctx) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)tree;
            Map renameVariablesMap = (Map)this.getCursor().getMessage("RENAME_VARIABLES_KEY", Collections.emptyMap());
            Set hasNameSet = (Set)this.getCursor().computeMessageIfAbsent("HAS_NAME_KEY", k -> new HashSet());
            for (Map.Entry entry : renameVariablesMap.entrySet()) {
                String toName;
                J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)entry.getKey();
                if (!this.shouldRename(hasNameSet, variable, toName = (String)entry.getValue())) continue;
                cu = (JavaSourceFile)new RenameVariable(variable, toName).visitNonNull((Tree)cu, (Object)ctx);
                hasNameSet.add(toName);
            }
            return cu;
        }
        return (J)super.postVisit((Tree)tree, (Object)ctx);
    }

    protected abstract boolean shouldRename(Set<String> var1, J.VariableDeclarations.NamedVariable var2, String var3);

    protected void renameVariable(J.VariableDeclarations.NamedVariable variable, String toName) {
        Cursor cu = (Cursor)this.getCursor().getPathAsCursors(c -> c.getValue() instanceof JavaSourceFile).next();
        ((LinkedHashMap)cu.computeMessageIfAbsent("RENAME_VARIABLES_KEY", k -> new LinkedHashMap())).put(variable, toName);
    }

    protected void hasNameKey(String variableName) {
        ((HashSet)((Cursor)this.getCursor().getPathAsCursors(c -> c.getValue() instanceof JavaSourceFile).next()).computeMessageIfAbsent("HAS_NAME_KEY", k -> new HashSet())).add(variableName);
    }
}

