/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.staticanalysis.RenameToCamelCase;

public class RenamePrivateFieldsToCamelCase
extends Recipe {
    public String getDisplayName() {
        return "Reformat private field names to camelCase";
    }

    public String getDescription() {
        return "Reformat private field names to camelCase to comply with Java naming convention. The recipe will not rename fields with default, protected or public access modifiers.The recipe will not rename private constants.The first character is set to lower case and existing capital letters are preserved. Special characters that are allowed in java field names `$` and `_` are removed. If a special character is removed the next valid alphanumeric will be capitalized. The recipe will not rename a field if the result already exists in the class, conflicts with a java reserved keyword, or the result is blank.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-116", "RSPEC-3008"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RenameToCamelCase(){

            @Override
            protected boolean shouldRename(Set<String> hasNameKey, J.VariableDeclarations.NamedVariable variable, String toName) {
                if (toName.isEmpty() || !Character.isAlphabetic(toName.charAt(0))) {
                    return false;
                }
                return !hasNameKey.contains(toName) && !hasNameKey.contains(variable.getSimpleName());
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                if (parentScope.getParent() != null && parentScope.getParent().getValue() instanceof J.ClassDeclaration && !(parentScope.getValue() instanceof J.ClassDeclaration) && variable.getVariableType() != null && variable.getVariableType().hasFlags(new Flag[]{Flag.Private}) && !variable.getVariableType().hasFlags(new Flag[]{Flag.Static, Flag.Final}) && !((J.ClassDeclaration)parentScope.getParent().getValue()).getType().getFullyQualifiedName().contains("$") && !NameCaseConvention.LOWER_CAMEL.matches(variable.getSimpleName())) {
                    String toName = NameCaseConvention.LOWER_CAMEL.format(variable.getSimpleName());
                    this.renameVariable(variable, toName);
                } else {
                    this.hasNameKey(variable.getSimpleName());
                }
                return super.visitVariable(variable, (Object)ctx);
            }

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof SourceFile);
            }
        };
    }
}

