/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.SocketContext;

public class SocketContextHandler {
    public static final SocketContextHandler instance = new SocketContextHandler();

    public void handle(Session session, Message message) {
        if (message == null) {
            return;
        }
        if (message.getHandled()) {
            return;
        }
        if (!Solon.app().enableWebSocketMvc() && session.method() == MethodType.WEBSOCKET) {
            return;
        }
        if (!Solon.app().enableSocketMvc() && session.method() == MethodType.SOCKET) {
            return;
        }
        if (Utils.isEmpty((String)message.resourceDescriptor())) {
            return;
        }
        try {
            SocketContext ctx = new SocketContext(session, message);
            Solon.app().tryHandle((Context)ctx);
            if (ctx.getHandled() || ctx.status() != 404) {
                ctx.commit();
            }
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
        }
    }
}

