/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ListenerProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionBase
implements Session {
    static final Logger log = LoggerFactory.getLogger(SessionBase.class);
    private int _flag = 0;
    private NvMap headerMap;
    private NvMap paramMap;
    private AtomicBoolean _handshaked = new AtomicBoolean();
    private Listener listener;
    private boolean _sendHeartbeatAuto = false;
    protected Message handshakeMessage;

    public int flag() {
        return this._flag;
    }

    public void flagSet(int flag) {
        this._flag = flag;
    }

    public String header(String name) {
        return (String)this.headerMap().get((Object)name);
    }

    public void headerSet(String name, String value) {
        this.headerMap().put(name, (Object)value);
    }

    public NvMap headerMap() {
        if (this.headerMap == null) {
            this.headerMap = new NvMap();
        }
        return this.headerMap;
    }

    public String param(String name) {
        return (String)this.paramMap().get((Object)name);
    }

    public void paramSet(String name, String value) {
        this.paramMap().put(name, (Object)value);
    }

    public NvMap paramMap() {
        if (this.paramMap == null) {
            String[] ss;
            this.paramMap = new NvMap();
            String query = this.uri().getQuery();
            for (String kv : ss = query.split("&")) {
                String[] s = kv.split("=");
                this.paramMap.put(s[0], (Object)s[1]);
            }
        }
        return this.paramMap;
    }

    public void setHandshaked(boolean handshaked) {
        this._handshaked.set(handshaked);
    }

    public boolean getHandshaked() {
        return this._handshaked.get();
    }

    public void send(Message message) {
        log.trace("Session send: {}", (Object)message);
    }

    public String sendAndResponse(String message) {
        return this.sendAndResponse(Message.wrap((String)message)).bodyAsString();
    }

    public String sendAndResponse(String message, int timeout) {
        return this.sendAndResponse(Message.wrap((String)message), timeout).bodyAsString();
    }

    public Message sendAndResponse(Message message) {
        return this.sendAndResponse(message, 0);
    }

    public Message sendAndResponse(Message message, int timeout) {
        if (Utils.isEmpty((String)message.key())) {
            throw new IllegalArgumentException("SendAndResponse message no key");
        }
        if (timeout < 1) {
            timeout = ListenerProxy.REQUEST_AND_RESPONSE_TIMEOUT_SECONDS;
        }
        CompletableFuture<Message> request = new CompletableFuture<Message>();
        ListenerProxy.regRequest(message, request);
        this.send(message);
        try {
            return request.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void sendAndCallback(String message, BiConsumer<String, Throwable> callback) {
        this.sendAndCallback(Message.wrap((String)message), (Message msg, Throwable err) -> {
            if (msg == null) {
                callback.accept((String)null, (Throwable)err);
            } else {
                callback.accept(msg.bodyAsString(), (Throwable)err);
            }
        });
    }

    public void sendAndCallback(Message message, BiConsumer<Message, Throwable> callback) {
        if (Utils.isEmpty((String)message.key())) {
            throw new IllegalArgumentException("sendAndCallback message no key");
        }
        CompletableFuture<Message> request = new CompletableFuture<Message>();
        ListenerProxy.regRequest(message, request);
        request.whenCompleteAsync((BiConsumer)callback);
        this.send(message);
    }

    public Listener listener() {
        return this.listener;
    }

    public void listener(Listener listener) {
        this.listener = listener;
    }

    protected void onOpen() {
        if (this.listener() != null) {
            this.listener().onOpen((Session)this);
        }
    }

    public void sendHeartbeat() {
        this.send(Message.wrapHeartbeat());
    }

    public void sendHeartbeatAuto(int intervalSeconds) {
        if (this._sendHeartbeatAuto) {
            return;
        }
        this._sendHeartbeatAuto = true;
        Utils.scheduled.scheduleWithFixedDelay(() -> {
            try {
                this.sendHeartbeat();
            }
            catch (Throwable ex) {
                EventBus.push((Object)ex);
            }
        }, 1L, intervalSeconds, TimeUnit.SECONDS);
    }

    public void sendHandshake(Message message) {
        if (message.flag() == 12) {
            try {
                this.send(message);
            }
            finally {
                this.handshakeMessage = message;
            }
        } else {
            throw new IllegalArgumentException("The message flag not handshake");
        }
    }

    public Message sendHandshakeAndResponse(Message message) {
        if (message.flag() == 12) {
            Message rst = this.sendAndResponse(message);
            this.handshakeMessage = message;
            return rst;
        }
        throw new IllegalArgumentException("The message flag not handshake");
    }
}

