/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.RequestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionBase
implements Session {
    static final Logger log = LoggerFactory.getLogger(SessionBase.class);
    private String pathNew;
    private int _flag = 0;
    private NvMap headerMap;
    private NvMap paramMap;
    private Map<String, Object> attrMap = null;
    private AtomicBoolean _handshaked = new AtomicBoolean();
    private Listener listener;
    private boolean _sendHeartbeatAuto = false;
    protected Message handshakeMessage;

    public void pathNew(String pathNew) {
        this.pathNew = pathNew;
    }

    public String pathNew() {
        if (this.pathNew == null) {
            return this.path();
        }
        return this.pathNew;
    }

    public int flag() {
        return this._flag;
    }

    public void flagSet(int flag) {
        this._flag = flag;
    }

    public String header(String name) {
        return (String)this.headerMap().get((Object)name);
    }

    public void headerSet(String name, String value) {
        this.headerMap().put(name, (Object)value);
    }

    public NvMap headerMap() {
        if (this.headerMap == null) {
            this.headerMap = new NvMap();
        }
        return this.headerMap;
    }

    public String param(String name) {
        return (String)this.paramMap().get((Object)name);
    }

    public void paramSet(String name, String value) {
        this.paramMap().put(name, (Object)value);
    }

    public NvMap paramMap() {
        if (this.paramMap == null) {
            String query;
            this.paramMap = new NvMap();
            if (this.uri() != null && Utils.isNotEmpty((String)(query = this.uri().getQuery()))) {
                String[] ss;
                for (String kv : ss = query.split("&")) {
                    int index = kv.indexOf(61);
                    if (index > -1) {
                        this.paramMap.put(kv.substring(0, index), (Object)kv.substring(index + 1));
                        continue;
                    }
                    this.paramMap.put(kv, null);
                }
            }
        }
        return this.paramMap;
    }

    public Map<String, Object> attrMap() {
        if (this.attrMap == null) {
            this.attrMap = new HashMap<String, Object>();
        }
        return this.attrMap;
    }

    public void setHandshaked(boolean handshaked) {
        this._handshaked.set(handshaked);
    }

    public boolean getHandshaked() {
        return this._handshaked.get();
    }

    public void send(Message message) {
        log.trace("Session send: {}", (Object)message);
    }

    public String sendAndResponse(String message) {
        return this.sendAndResponse(Message.wrap((String)message)).bodyAsString();
    }

    public String sendAndResponse(String message, int timeout) {
        return this.sendAndResponse(Message.wrap((String)message), timeout).bodyAsString();
    }

    public Message sendAndResponse(Message message) {
        return this.sendAndResponse(message, 0);
    }

    public Message sendAndResponse(Message message, int timeout) {
        if (Utils.isEmpty((String)message.key())) {
            throw new IllegalArgumentException("SendAndResponse message no key");
        }
        if (timeout < 1) {
            timeout = RequestManager.REQUEST_AND_RESPONSE_TIMEOUT_SECONDS;
        }
        CompletableFuture<Message> request = new CompletableFuture<Message>();
        RequestManager.register(message, request);
        this.send(message);
        try {
            Message message2 = request.get(timeout, TimeUnit.SECONDS);
            return message2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            RequestManager.remove(message.key());
        }
    }

    public void sendAndCallback(String message, BiConsumer<String, Throwable> callback) {
        this.sendAndCallback(Message.wrap((String)message), (Message msg, Throwable err) -> {
            if (msg == null) {
                callback.accept((String)null, (Throwable)err);
            } else {
                callback.accept(msg.bodyAsString(), (Throwable)err);
            }
        });
    }

    public void sendAndCallback(Message message, BiConsumer<Message, Throwable> callback) {
        if (Utils.isEmpty((String)message.key())) {
            throw new IllegalArgumentException("sendAndCallback message no key");
        }
        CompletableFuture<Message> request = new CompletableFuture<Message>();
        RequestManager.register(message, request);
        request.whenCompleteAsync((BiConsumer)callback);
        this.send(message);
    }

    public Listener listener() {
        return this.listener;
    }

    public void listener(Listener listener) {
        this.listener = listener;
    }

    protected void onOpen() {
        if (this.listener() != null) {
            this.listener().onOpen((Session)this);
        }
    }

    public void sendHeartbeat() {
        this.send(Message.wrapHeartbeat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeartbeatAuto(int intervalSeconds) {
        if (this._sendHeartbeatAuto) {
            return;
        }
        SessionBase sessionBase = this;
        synchronized (sessionBase) {
            if (this._sendHeartbeatAuto) {
                return;
            }
            this._sendHeartbeatAuto = true;
            Utils.scheduled.scheduleWithFixedDelay(() -> {
                try {
                    this.sendHeartbeat();
                }
                catch (Throwable ex) {
                    EventBus.push((Object)ex);
                }
            }, 1L, intervalSeconds, TimeUnit.SECONDS);
        }
    }

    public void sendHandshake(Message message) {
        if (message.flag() == 12) {
            try {
                this.send(message);
            }
            finally {
                this.handshakeMessage = message;
            }
        } else {
            throw new IllegalArgumentException("The message flag not handshake");
        }
    }

    public Message sendHandshakeAndResponse(Message message) {
        if (message.flag() == 12) {
            Message rst = this.sendAndResponse(message);
            this.handshakeMessage = message;
            return rst;
        }
        throw new IllegalArgumentException("The message flag not handshake");
    }
}

