/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.string;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;

public class NDArrayStrings {
    public static final String EMPTY_ARRAY_STR = "[]";
    public static final long DEFAULT_MAX_PRINT_ELEMENTS = 1000L;
    private static long maxPrintElements = 1000L;
    private String colSep = ",";
    private String newLineSep = ",";
    private int padding = 7;
    private int precision = 4;
    private double minToPrintWithoutSwitching;
    private double maxToPrintWithoutSwitching;
    private String scientificFormat = "";
    private DecimalFormat decimalFormat;
    private boolean dontOverrideFormat = false;

    public NDArrayStrings() {
        this(",", 4);
    }

    public NDArrayStrings(String colSep) {
        this(colSep, 4);
    }

    public NDArrayStrings(int precision) {
        this(",", precision);
    }

    public NDArrayStrings(String colSep, int precision) {
        this.colSep = colSep;
        if (!colSep.replaceAll("\\s", "").equals(",")) {
            this.newLineSep = "";
        }
        this.precision = precision;
        String decFormatNum = "0.";
        while (precision > 0) {
            decFormatNum = decFormatNum + "0";
            --precision;
        }
        this.decimalFormat = this.localeIndifferentDecimalFormat(decFormatNum);
    }

    public NDArrayStrings(String colSep, String decFormat) {
        this.colSep = colSep;
        this.decimalFormat = this.localeIndifferentDecimalFormat(decFormat);
        this.padding = decFormat.toUpperCase().contains("E") ? decFormat.length() + 3 : decFormat.length() + 1;
        this.dontOverrideFormat = true;
    }

    public String format(INDArray arr) {
        return this.format(arr, true);
    }

    public String format(INDArray arr, boolean summarize) {
        if (arr.isEmpty()) {
            return EMPTY_ARRAY_STR;
        }
        this.scientificFormat = "0.";
        for (int addPrecision = this.precision; addPrecision > 0; --addPrecision) {
            this.scientificFormat = this.scientificFormat + "#";
        }
        this.scientificFormat = this.scientificFormat + "E0";
        if (this.scientificFormat.length() + 2 > this.padding) {
            this.padding = this.scientificFormat.length() + 2;
        }
        this.maxToPrintWithoutSwitching = Math.pow(10.0, this.precision);
        this.minToPrintWithoutSwitching = 1.0 / this.maxToPrintWithoutSwitching;
        return this.format(arr, 0, summarize && arr.length() > maxPrintElements);
    }

    private String format(INDArray arr, int offset, boolean summarize) {
        int rank = arr.rank();
        if (arr.isScalar()) {
            if (arr.isR()) {
                double arrElement = arr.getDouble(0L);
                if (!this.dontOverrideFormat && (Math.abs(arrElement) < this.minToPrintWithoutSwitching && arrElement != 0.0 || Math.abs(arrElement) >= this.maxToPrintWithoutSwitching)) {
                    String asString = this.localeIndifferentDecimalFormat(this.scientificFormat).format(arrElement);
                    asString = asString.replace('E', 'e');
                    return asString;
                }
                if (arr.getDouble(0L) == 0.0) {
                    return "0";
                }
                return this.decimalFormat.format(arr.getDouble(0L));
            }
            if (arr.isZ()) {
                long arrElement = arr.getLong(0L);
                return String.valueOf(arrElement);
            }
            if (arr.isB()) {
                long arrElement = arr.getLong(0L);
                return arrElement == 0L ? "false" : "true";
            }
            if (arr.dataType() == DataType.UTF8) {
                String s = arr.getString(0L);
                return "\"" + s.replaceAll("\n", "\\n") + "\"";
            }
            throw new ND4JIllegalStateException();
        }
        if (rank == 1) {
            return this.vectorToString(arr, summarize);
        }
        if (arr.isRowVector()) {
            if (offset == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(this.vectorToString(arr, summarize));
                sb.append("]");
                return sb.toString();
            }
            return this.vectorToString(arr, summarize);
        }
        ++offset;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        long nSlices = arr.slices();
        int i = 0;
        while ((long)i < nSlices) {
            if (summarize && i > 2 && (long)i < nSlices - 3L) {
                sb.append(" ...");
                sb.append(this.newLineSep).append(" \n");
                sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
                sb.append(StringUtils.repeat((String)" ", (int)offset));
                i = Math.max(i, (int)nSlices - 4);
            } else {
                if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                    sb.append("[");
                }
                if (arr.ordering() == 'f' && arr.rank() > 2 && arr.size(arr.rank() - 1) == 1L) {
                    sb.append(this.format(arr.dup('c').slice(i), offset, summarize));
                } else if (arr.rank() <= 1 || arr.length() == 1L) {
                    sb.append(this.format(Nd4j.scalar(arr.getDouble(0L)), offset, summarize));
                } else {
                    sb.append(this.format(arr.slice(i), offset, summarize));
                }
                if ((long)i != nSlices - 1L) {
                    if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                        sb.append("]");
                    }
                    sb.append(this.newLineSep).append(" \n");
                    sb.append(StringUtils.repeat((String)"\n", (int)(rank - 2)));
                    sb.append(StringUtils.repeat((String)" ", (int)offset));
                } else if (arr.rank() == 3 && arr.slice(i).isRowVector()) {
                    sb.append("]");
                }
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private String vectorToString(INDArray arr, boolean summarize) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        long l = arr.length();
        int i = 0;
        while ((long)i < l) {
            if (summarize && i > 2 && (long)i < l - 3L) {
                sb.append("  ...");
                i = Math.max(i, (int)l - 4);
            } else if (arr.isR()) {
                double arrElement = arr.getDouble((long)i);
                if (!this.dontOverrideFormat && (Math.abs(arrElement) < this.minToPrintWithoutSwitching && arrElement != 0.0 || Math.abs(arrElement) >= this.maxToPrintWithoutSwitching)) {
                    String asString = this.localeIndifferentDecimalFormat(this.scientificFormat).format(arrElement);
                    asString = asString.replace('E', 'e');
                    sb.append(String.format("%1$" + this.padding + "s", asString));
                } else if (arrElement == 0.0) {
                    sb.append(String.format("%1$" + this.padding + "s", 0));
                } else {
                    sb.append(String.format("%1$" + this.padding + "s", this.decimalFormat.format(arrElement)));
                }
            } else if (arr.isZ()) {
                long arrElement = arr.getLong((long)i);
                sb.append(String.format("%1$" + this.padding + "s", arrElement));
            } else if (arr.isB()) {
                long arrElement = arr.getLong((long)i);
                sb.append(String.format("%1$" + this.padding + "s", arrElement == 0L ? "false" : "true"));
            } else if (arr.dataType() == DataType.UTF8) {
                String s = arr.getString(i);
                s = "\"" + s.replaceAll("\n", "\\n") + "\"";
                sb.append(s);
            }
            if ((long)i < l - 1L && (!summarize || i < 2 || (long)i > l - 3L || summarize && l == 6L)) {
                sb.append(this.colSep);
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private DecimalFormat localeIndifferentDecimalFormat(String pattern) {
        return new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(Locale.US));
    }

    public static void setMaxPrintElements(long maxPrintElements) {
        NDArrayStrings.maxPrintElements = maxPrintElements;
    }

    public static long getMaxPrintElements() {
        return maxPrintElements;
    }
}

