/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.memory.deallocation;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.lang3.RandomUtils;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.deallocation.DeallocatableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeallocatorService {
    private static final Logger log = LoggerFactory.getLogger(DeallocatorService.class);
    private Thread[] deallocatorThreads;
    private ReferenceQueue<Deallocatable>[] queues;
    private Map<String, DeallocatableReference> referenceMap = new ConcurrentHashMap<String, DeallocatableReference>();
    private List<List<ReferenceQueue<Deallocatable>>> deviceMap = new ArrayList<List<ReferenceQueue<Deallocatable>>>();

    public DeallocatorService() {
        int e;
        int numDevices = Nd4j.getAffinityManager().getNumberOfDevices();
        int numThreads = Math.max(2, numDevices * 2);
        for (e = 0; e < numDevices; ++e) {
            this.deviceMap.add(new ArrayList());
        }
        this.deallocatorThreads = new Thread[numThreads];
        this.queues = new ReferenceQueue[numThreads];
        for (e = 0; e < numThreads; ++e) {
            log.debug("Starting deallocator thread {}", (Object)(e + 1));
            this.queues[e] = new ReferenceQueue();
            this.deallocatorThreads[e] = new DeallocatorServiceThread(this.queues[e], e);
            this.deallocatorThreads[e].setName("DeallocatorServiceThread_" + e);
            this.deallocatorThreads[e].setDaemon(true);
            int deviceId = e % numDevices;
            Nd4j.getAffinityManager().attachThreadToDevice(this.deallocatorThreads[e], (Integer)deviceId);
            this.deviceMap.get(deviceId).add(this.queues[e]);
            this.deallocatorThreads[e].start();
        }
    }

    public void pickObject(@NonNull Deallocatable deallocatable) {
        if (deallocatable == null) {
            throw new NullPointerException("deallocatable is marked @NonNull but is null");
        }
        int desiredDevice = deallocatable.targetDevice();
        List<ReferenceQueue<Deallocatable>> map = this.deviceMap.get(desiredDevice);
        DeallocatableReference reference = new DeallocatableReference(deallocatable, map.get(RandomUtils.nextInt((int)0, (int)map.size())));
        this.referenceMap.put(deallocatable.getUniqueId(), reference);
    }

    private class DeallocatorServiceThread
    extends Thread
    implements Runnable {
        private final ReferenceQueue<Deallocatable> queue;
        private final int threadIdx;

        private DeallocatorServiceThread(ReferenceQueue<Deallocatable> queue, int threadIdx) {
            if (queue == null) {
                throw new NullPointerException("queue is marked @NonNull but is null");
            }
            this.queue = queue;
            this.threadIdx = threadIdx;
        }

        @Override
        public void run() {
            boolean canRun = true;
            long cnt = 0L;
            while (canRun) {
                DeallocatableReference reference;
                if (Nd4j.getMemoryManager().isPeriodicGcActive() && this.threadIdx == 0 && Nd4j.getMemoryManager().getAutoGcWindow() > 0) {
                    reference = (DeallocatableReference)this.queue.poll();
                    if (reference == null) {
                        int timeout = Nd4j.getMemoryManager().getAutoGcWindow();
                        try {
                            Thread.sleep(Nd4j.getMemoryManager().getAutoGcWindow());
                            Nd4j.getMemoryManager().invokeGc();
                        }
                        catch (InterruptedException e) {
                            canRun = false;
                        }
                        continue;
                    }
                    reference.getDeallocator().deallocate();
                    DeallocatorService.this.referenceMap.remove(reference.getId());
                    continue;
                }
                try {
                    reference = (DeallocatableReference)this.queue.remove();
                    if (reference == null) continue;
                    reference.getDeallocator().deallocate();
                    DeallocatorService.this.referenceMap.remove(reference.getId());
                }
                catch (InterruptedException e) {
                    canRun = false;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

