/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.memory;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.memory.MemcpyDirection;
import org.nd4j.linalg.memory.MemoryManager;
import org.nd4j.linalg.memory.abstracts.DummyWorkspace;

public abstract class BasicMemoryManager
implements MemoryManager {
    protected AtomicInteger frequency = new AtomicInteger(0);
    protected AtomicLong freqCounter = new AtomicLong(0L);
    protected AtomicLong lastGcTime = new AtomicLong(System.currentTimeMillis());
    protected AtomicBoolean periodicEnabled = new AtomicBoolean(false);
    protected AtomicInteger averageLoopTime = new AtomicInteger(0);
    protected AtomicInteger noGcWindow = new AtomicInteger(100);
    protected AtomicBoolean averagingEnabled = new AtomicBoolean(false);
    protected static final int intervalTail = 100;
    protected Queue<Integer> intervals = new ConcurrentLinkedQueue<Integer>();
    private ThreadLocal<MemoryWorkspace> workspace = new ThreadLocal();
    private ThreadLocal<MemoryWorkspace> tempWorkspace = new ThreadLocal();

    @Override
    public Pointer allocate(long bytes, MemoryKind kind, boolean initialize) {
        throw new UnsupportedOperationException("This method isn't available for this backend");
    }

    @Override
    public void collect(INDArray ... arrays) {
        throw new UnsupportedOperationException("This method isn't implemented yet");
    }

    @Override
    public void toggleAveraging(boolean enabled) {
        this.averagingEnabled.set(enabled);
    }

    @Override
    public void purgeCaches() {
        throw new UnsupportedOperationException("This method isn't implemented yet");
    }

    @Override
    public void memcpy(DataBuffer dstBuffer, DataBuffer srcBuffer) {
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy((Pointer)dstBuffer.addressPointer(), (Pointer)srcBuffer.addressPointer(), (long)(srcBuffer.length() * (long)srcBuffer.getElementSize()));
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, srcBuffer.length() * (long)srcBuffer.getElementSize(), MemcpyDirection.HOST_TO_HOST);
    }

    @Override
    public void notifyScopeEntered() {
    }

    @Override
    public void notifyScopeLeft() {
    }

    @Override
    public void invokeGcOccasionally() {
        long currentTime = System.currentTimeMillis();
        if (this.averagingEnabled.get()) {
            this.intervals.add((int)(currentTime - this.lastGcTime.get()));
        }
        if (this.frequency.get() > 0 && this.freqCounter.incrementAndGet() % (long)this.frequency.get() == 0L && currentTime > this.getLastGcTime() + (long)this.getAutoGcWindow()) {
            System.gc();
            this.lastGcTime.set(System.currentTimeMillis());
        }
        if (this.averagingEnabled.get() && this.intervals.size() > 100) {
            this.intervals.remove();
        }
    }

    @Override
    public void invokeGc() {
        System.gc();
        this.lastGcTime.set(System.currentTimeMillis());
    }

    @Override
    public boolean isPeriodicGcActive() {
        return this.periodicEnabled.get();
    }

    @Override
    public void setOccasionalGcFrequency(int frequency) {
        this.frequency.set(frequency);
    }

    @Override
    public void setAutoGcWindow(int windowMillis) {
        this.noGcWindow.set(windowMillis);
    }

    @Override
    public int getAutoGcWindow() {
        return this.noGcWindow.get();
    }

    @Override
    public int getOccasionalGcFrequency() {
        return this.frequency.get();
    }

    @Override
    public long getLastGcTime() {
        return this.lastGcTime.get();
    }

    @Override
    public void togglePeriodicGc(boolean enabled) {
        this.periodicEnabled.set(enabled);
    }

    @Override
    public int getAverageLoopTime() {
        if (this.averagingEnabled.get()) {
            int cnt = 0;
            for (Integer value : this.intervals) {
                cnt += value.intValue();
            }
            return cnt /= this.intervals.size();
        }
        return 0;
    }

    @Override
    public MemoryWorkspace getCurrentWorkspace() {
        return this.workspace.get();
    }

    @Override
    public void setCurrentWorkspace(MemoryWorkspace workspace) {
        this.workspace.set(workspace);
    }

    @Override
    public MemoryWorkspace scopeOutOfWorkspaces() {
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (workspace == null) {
            return new DummyWorkspace();
        }
        return new DummyWorkspace().notifyScopeEntered();
    }

    @Override
    public void releaseCurrentContext() {
    }
}

