/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.Indices;
import org.nd4j.linalg.indexing.IntervalIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.NewAxis;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.indexing.SpecifiedIndex;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NDArrayIndex
implements INDArrayIndex {
    private static final Logger log = LoggerFactory.getLogger(NDArrayIndex.class);
    private long[] indices;
    private static NewAxis NEW_AXIS = new NewAxis();

    public static INDArrayIndex point(long point) {
        return new PointIndex(point);
    }

    public static INDArrayIndex[] indexesFor(long ... shape) {
        INDArrayIndex[] ret = new INDArrayIndex[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            ret[i] = NDArrayIndex.point(shape[i]);
        }
        return ret;
    }

    public static long offset(INDArray arr, long ... offsets) {
        return NDArrayIndex.offset(arr.stride(), offsets);
    }

    public static long offset(INDArray arr, INDArrayIndex ... indices) {
        return NDArrayIndex.offset(arr.stride(), Indices.offsets(arr.shape(), indices));
    }

    public static void updateForNewAxes(INDArray arr, INDArrayIndex ... indexes) {
        int numNewAxes = NDArrayIndex.numNewAxis(indexes);
        if (numNewAxes >= 1 && (indexes[0].length() > 1L || indexes[0] instanceof NDArrayIndexAll)) {
            ArrayList<Long> newShape = new ArrayList<Long>();
            ArrayList<Long> newStrides = new ArrayList<Long>();
            int currDimension = 0;
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] instanceof NewAxis) {
                    newShape.add(1L);
                    newStrides.add(0L);
                    continue;
                }
                newShape.add(arr.size(currDimension));
                newStrides.add(arr.size(currDimension));
                ++currDimension;
            }
            while (currDimension < arr.rank()) {
                newShape.add(Long.valueOf(currDimension));
                newStrides.add(Long.valueOf(currDimension));
                ++currDimension;
            }
            long[] newShapeArr = Longs.toArray(newShape);
            long[] newStrideArr = Longs.toArray(newStrides);
            arr.setShape(newShapeArr);
            arr.setStride(newStrideArr);
        } else if (numNewAxes > 0) {
            long[] newShape = Longs.concat((long[][])new long[][]{ArrayUtil.toLongArray((int[])ArrayUtil.nTimes((int)numNewAxes, (int)1)), arr.shape()});
            long[] newStrides = Longs.concat((long[][])new long[][]{new long[numNewAxes], arr.stride()});
            arr.setShape(newShape);
            arr.setStride(newStrides);
        }
    }

    public static long offset(long[] strides, long[] offsets) {
        int ret = 0;
        if (ArrayUtil.prod((long[])offsets) == 1) {
            for (int i = 0; i < offsets.length; ++i) {
                ret = (int)((long)ret + offsets[i] * strides[i]);
            }
        } else {
            for (int i = 0; i < offsets.length; ++i) {
                ret = (int)((long)ret + offsets[i] * strides[i]);
            }
        }
        return ret;
    }

    public static long offset(int[] strides, long[] offsets) {
        int ret = 0;
        if (ArrayUtil.prodLong((long[])offsets) == 1L) {
            for (int i = 0; i < offsets.length; ++i) {
                ret = (int)((long)ret + offsets[i] * (long)strides[i]);
            }
        } else {
            for (int i = 0; i < offsets.length; ++i) {
                ret = (int)((long)ret + offsets[i] * (long)strides[i]);
            }
        }
        return ret;
    }

    public static INDArrayIndex[] nTimes(INDArrayIndex copy, int n) {
        INDArrayIndex[] ret = new INDArrayIndex[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = copy;
        }
        return ret;
    }

    public NDArrayIndex(long ... indices) {
        this.indices = indices;
    }

    public static INDArrayIndex all() {
        return new NDArrayIndexAll();
    }

    public static INDArrayIndex indices(long ... indices) {
        return new SpecifiedIndex(indices);
    }

    public static INDArrayIndex newAxis() {
        return NEW_AXIS;
    }

    public static INDArrayIndex[] resolve(INDArray arr, INDArrayIndex ... intendedIndexes) {
        return NDArrayIndex.resolve(NDArrayIndex.allFor(arr), intendedIndexes);
    }

    public static int numPoints(INDArrayIndex ... indexes) {
        int ret = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(indexes[i] instanceof PointIndex)) continue;
            ++ret;
        }
        return ret;
    }

    public static INDArrayIndex[] resolveLong(long[] shapeInfo, INDArrayIndex ... intendedIndexes) {
        int numSpecified = 0;
        for (int i = 0; i < intendedIndexes.length; ++i) {
            if (!(intendedIndexes[i] instanceof SpecifiedIndex)) continue;
            ++numSpecified;
        }
        if (numSpecified > 0) {
            long[] shape = Shape.shapeOf(shapeInfo);
            INDArrayIndex[] ret = new INDArrayIndex[intendedIndexes.length];
            for (int i = 0; i < intendedIndexes.length; ++i) {
                if (intendedIndexes[i] instanceof SpecifiedIndex) {
                    ret[i] = intendedIndexes[i];
                    continue;
                }
                if (intendedIndexes[i] instanceof NDArrayIndexAll) {
                    SpecifiedIndex specifiedIndex = new SpecifiedIndex(ArrayUtil.range((long)0L, (long)shape[i]));
                    ret[i] = specifiedIndex;
                    continue;
                }
                if (intendedIndexes[i] instanceof IntervalIndex) {
                    IntervalIndex intervalIndex = (IntervalIndex)intendedIndexes[i];
                    ret[i] = new SpecifiedIndex(ArrayUtil.range((long)intervalIndex.begin, (long)intervalIndex.end(), (long)intervalIndex.stride()));
                    continue;
                }
                if (!(intendedIndexes[i] instanceof PointIndex)) continue;
                ret[i] = intendedIndexes[i];
            }
            return ret;
        }
        int rank = Shape.rank(shapeInfo);
        long[] shape = Shape.shapeOf(shapeInfo);
        if (intendedIndexes.length >= rank || Shape.isVector(shapeInfo) && intendedIndexes.length == 1) {
            if (Shape.rank(shapeInfo) == 1) {
                return intendedIndexes;
            }
            if (Shape.isRowVectorShape(shapeInfo) && intendedIndexes.length == 1) {
                INDArrayIndex[] ret = new INDArrayIndex[2];
                ret[0] = NDArrayIndex.point(0L);
                long size = 1L == shape[0] && rank == 2 ? shape[1] : shape[0];
                ret[1] = NDArrayIndex.validate(size, intendedIndexes[0]);
                return ret;
            }
            ArrayList<INDArrayIndex> retList = new ArrayList<INDArrayIndex>(intendedIndexes.length);
            for (int i = 0; i < intendedIndexes.length; ++i) {
                if (i < rank) {
                    retList.add(NDArrayIndex.validate(shape[i], intendedIndexes[i]));
                    continue;
                }
                retList.add(intendedIndexes[i]);
            }
            return retList.toArray(new INDArrayIndex[retList.size()]);
        }
        ArrayList<INDArrayIndex> retList = new ArrayList<INDArrayIndex>(intendedIndexes.length + 1);
        int numNewAxes = 0;
        if (Shape.isMatrix(shape) && intendedIndexes.length == 1) {
            retList.add(NDArrayIndex.validate(shape[0], intendedIndexes[0]));
            retList.add(NDArrayIndex.all());
        } else {
            for (int i = 0; i < intendedIndexes.length; ++i) {
                retList.add(NDArrayIndex.validate(shape[i], intendedIndexes[i]));
                if (!(intendedIndexes[i] instanceof NewAxis)) continue;
                ++numNewAxes;
            }
        }
        int length = rank + numNewAxes;
        while (retList.size() < length) {
            retList.add(NDArrayIndex.all());
        }
        return retList.toArray(new INDArrayIndex[retList.size()]);
    }

    public static INDArrayIndex[] resolve(int[] shape, INDArrayIndex ... intendedIndexes) {
        return NDArrayIndex.resolve(ArrayUtil.toLongArray((int[])shape), intendedIndexes);
    }

    public static INDArrayIndex[] resolve(long[] shape, INDArrayIndex ... intendedIndexes) {
        if (intendedIndexes.length >= shape.length || Shape.isVector(shape) && intendedIndexes.length == 1) {
            if (Shape.isRowVectorShape(shape) && intendedIndexes.length == 1) {
                INDArrayIndex[] ret = new INDArrayIndex[2];
                ret[0] = NDArrayIndex.point(0L);
                long size = 1L == shape[0] && shape.length == 2 ? shape[1] : shape[0];
                ret[1] = NDArrayIndex.validate(size, intendedIndexes[0]);
                return ret;
            }
            ArrayList<INDArrayIndex> retList = new ArrayList<INDArrayIndex>(intendedIndexes.length);
            for (int i = 0; i < intendedIndexes.length; ++i) {
                if (i < shape.length) {
                    retList.add(NDArrayIndex.validate(shape[i], intendedIndexes[i]));
                    continue;
                }
                retList.add(intendedIndexes[i]);
            }
            return retList.toArray(new INDArrayIndex[retList.size()]);
        }
        ArrayList<INDArrayIndex> retList = new ArrayList<INDArrayIndex>(intendedIndexes.length + 1);
        int numNewAxes = 0;
        if (Shape.isMatrix(shape) && intendedIndexes.length == 1) {
            retList.add(NDArrayIndex.validate(shape[0], intendedIndexes[0]));
            retList.add(NDArrayIndex.all());
        } else {
            for (int i = 0; i < intendedIndexes.length; ++i) {
                retList.add(NDArrayIndex.validate(shape[i], intendedIndexes[i]));
                if (!(intendedIndexes[i] instanceof NewAxis)) continue;
                ++numNewAxes;
            }
        }
        int length = shape.length + numNewAxes;
        while (retList.size() < length) {
            retList.add(NDArrayIndex.all());
        }
        return retList.toArray(new INDArrayIndex[retList.size()]);
    }

    protected static INDArrayIndex validate(long size, INDArrayIndex index) {
        if ((index instanceof IntervalIndex || index instanceof PointIndex) && size <= index.offset()) {
            throw new IllegalArgumentException("NDArrayIndex is out of range. Beginning index: " + index.offset() + " must be less than its size: " + size);
        }
        if (index instanceof IntervalIndex && index.end() > size) {
            throw new IllegalArgumentException("NDArrayIndex is out of range. End index: " + index.end() + " must be less than its size: " + size);
        }
        if (index instanceof IntervalIndex && size < index.end()) {
            long begin = ((IntervalIndex)index).begin;
            index = NDArrayIndex.interval(begin, index.stride(), size);
        }
        return index;
    }

    public static INDArrayIndex[] resolve(INDArrayIndex[] allIndex, INDArrayIndex ... intendedIndexes) {
        int numNewAxes = NDArrayIndex.numNewAxis(intendedIndexes);
        Object[] all = new INDArrayIndex[allIndex.length + numNewAxes];
        Arrays.fill(all, NDArrayIndex.all());
        for (int i = 0; i < allIndex.length && i < intendedIndexes.length; ++i) {
            if (intendedIndexes[i] instanceof NDArrayIndex) {
                NDArrayIndex idx = (NDArrayIndex)intendedIndexes[i];
                if (idx.indices.length == 1) {
                    intendedIndexes[i] = new PointIndex(idx.indices[0]);
                }
            }
            all[i] = intendedIndexes[i];
        }
        return all;
    }

    public static int numNewAxis(INDArrayIndex ... axes) {
        int ret = 0;
        for (INDArrayIndex index : axes) {
            if (!(index instanceof NewAxis)) continue;
            ++ret;
        }
        return ret;
    }

    public static INDArrayIndex[] allFor(INDArray arr) {
        INDArrayIndex[] ret = new INDArrayIndex[arr.rank()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NDArrayIndex.all();
        }
        return ret;
    }

    public static INDArrayIndex[] createCoveringShape(int[] shape) {
        INDArrayIndex[] ret = new INDArrayIndex[shape.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NDArrayIndex.interval(0, shape[i]);
        }
        return ret;
    }

    public static INDArrayIndex[] createCoveringShape(long[] shape) {
        INDArrayIndex[] ret = new INDArrayIndex[shape.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NDArrayIndex.interval(0L, shape[i]);
        }
        return ret;
    }

    public static INDArrayIndex[] rangeOfLength(INDArrayIndex[] indexes) {
        INDArrayIndex[] indexesRet = new INDArrayIndex[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexesRet[i] = NDArrayIndex.interval(0L, indexes[i].length());
        }
        return indexesRet;
    }

    public static INDArrayIndex interval(long begin, long stride, long end, long max) {
        if (begin < 0L) {
            begin += max;
        }
        if (end < 0L) {
            end += max;
        }
        if (Math.abs(begin - end) < 1L) {
            ++end;
        }
        if (stride > 1L && Math.abs(begin - end) == 1L) {
            end *= stride;
        }
        return NDArrayIndex.interval(begin, stride, end, false);
    }

    public static INDArrayIndex interval(long begin, long stride, long end) {
        if (Math.abs(begin - end) < 1L) {
            ++end;
        }
        if (stride > 1L && Math.abs(begin - end) == 1L) {
            end *= stride;
        }
        return NDArrayIndex.interval(begin, stride, end, false);
    }

    public static INDArrayIndex interval(int begin, int stride, int end, boolean inclusive) {
        Preconditions.checkArgument((begin <= end ? 1 : 0) != 0, (String)"Beginning index (%s) in range must be less than or equal to end (%s)", (int)begin, (int)end);
        IntervalIndex index = new IntervalIndex(inclusive, stride);
        index.init(begin, (long)end);
        return index;
    }

    public static INDArrayIndex interval(long begin, long stride, long end, long max, boolean inclusive) {
        Preconditions.checkArgument((begin <= end ? 1 : 0) != 0, (String)"Beginning index (%s) in range must be less than or equal to end (%s)", (long)begin, (long)end);
        IntervalIndex index = new IntervalIndex(inclusive, stride);
        index.init(begin, end);
        return index;
    }

    public static INDArrayIndex interval(long begin, long stride, long end, boolean inclusive) {
        Preconditions.checkArgument((begin <= end ? 1 : 0) != 0, (String)"Beginning index (%s) in range must be less than or equal to end (%s)", (long)begin, (long)end);
        IntervalIndex index = new IntervalIndex(inclusive, stride);
        index.init(begin, end);
        return index;
    }

    public static INDArrayIndex interval(int begin, int end) {
        return NDArrayIndex.interval(begin, 1, end, false);
    }

    public static INDArrayIndex interval(long begin, long end) {
        return NDArrayIndex.interval(begin, 1L, end, false);
    }

    public static INDArrayIndex interval(long begin, long end, boolean inclusive) {
        return NDArrayIndex.interval(begin, 1L, end, inclusive);
    }

    @Override
    public long end() {
        if (this.indices != null && this.indices.length > 0) {
            return this.indices[this.indices.length - 1];
        }
        return 0L;
    }

    @Override
    public long offset() {
        if (this.indices.length < 1) {
            return 0L;
        }
        return this.indices[0];
    }

    @Override
    public long length() {
        return this.indices.length;
    }

    @Override
    public long stride() {
        return 1L;
    }

    @Override
    public void reverse() {
        ArrayUtil.reverse((long[])this.indices);
    }

    public String toString() {
        return "NDArrayIndex{indices=" + Arrays.toString(this.indices) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof INDArrayIndex)) {
            return false;
        }
        NDArrayIndex that = (NDArrayIndex)o;
        return Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Arrays.hashCode(this.indices);
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
    }

    @Override
    public void init(long begin, long end, long max) {
    }

    @Override
    public void init(long begin, long end) {
    }
}

