/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MultiHeadDotProductAttention
extends DynamicCustomOp {
    private boolean withWeights;
    private boolean scaled;

    public MultiHeadDotProductAttention(SameDiff sameDiff, SDVariable queries, SDVariable keys, SDVariable values, SDVariable Wq, SDVariable Wk, SDVariable Wv, SDVariable Wo, SDVariable mask, boolean scaled, boolean withWeights) {
        SDVariable[] sDVariableArray;
        if (mask == null) {
            SDVariable[] sDVariableArray2 = new SDVariable[7];
            sDVariableArray2[0] = queries;
            sDVariableArray2[1] = keys;
            sDVariableArray2[2] = values;
            sDVariableArray2[3] = Wq;
            sDVariableArray2[4] = Wk;
            sDVariableArray2[5] = Wv;
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[6] = Wo;
        } else {
            SDVariable[] sDVariableArray3 = new SDVariable[8];
            sDVariableArray3[0] = queries;
            sDVariableArray3[1] = keys;
            sDVariableArray3[2] = values;
            sDVariableArray3[3] = Wq;
            sDVariableArray3[4] = Wk;
            sDVariableArray3[5] = Wv;
            sDVariableArray3[6] = Wo;
            sDVariableArray = sDVariableArray3;
            sDVariableArray3[7] = mask;
        }
        super(null, sameDiff, sDVariableArray, false);
        this.scaled = scaled;
        this.withWeights = withWeights;
        this.addIArgument(scaled ? 1 : 0);
        this.addIArgument(withWeights ? 1 : 0);
    }

    @Override
    public String opName() {
        return "multi_head_dot_product_attention";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradient) {
        return this.sameDiff.f().multiHeadDotProductAttentionBp(this.arg(0), this.arg(1), this.arg(2), this.arg(3), this.arg(4), this.arg(5), this.arg(6), gradient.get(0), this.args().length > 7 ? this.arg(7) : null, this.scaled);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 7 || dataTypes.size() == 8) ? 1 : 0) != 0, (String)"Expected 7 or 8 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (int i = 0; i < dataTypes.size(); ++i) {
            Preconditions.checkState((boolean)dataTypes.get(i).isFPType(), (String)"Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            if (i <= 0) continue;
            Preconditions.checkState((first == dataTypes.get(i) ? 1 : 0) != 0, (String)"All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        if (this.withWeights) {
            return Arrays.asList(first, first);
        }
        return Collections.singletonList(first);
    }

    @Override
    public int getNumOutputs() {
        if (this.withWeights) {
            return 2;
        }
        return 1;
    }

    public MultiHeadDotProductAttention() {
    }
}

