/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public class Choose
extends DynamicCustomOp {
    private Condition condition;

    public Choose(SameDiff sameDiff, SDVariable[] args, Condition condition) {
        super(null, sameDiff, args);
        if (condition == null) {
            throw new ND4JIllegalArgumentException("Must specify a condition.");
        }
        this.inPlace = true;
        this.inplaceCall = true;
        this.addIArgument(condition.condtionNum());
        this.condition = condition;
    }

    public Choose(String opName, INDArray[] inputs, INDArray[] outputs, List<Double> tArguments, List<Integer> iArguments) {
        super(opName, inputs, outputs, tArguments, iArguments);
    }

    public Choose(String opName, INDArray[] inputs, Condition condition) {
        super(opName, inputs, null);
        if (condition == null) {
            throw new ND4JIllegalArgumentException("Must specify a condition.");
        }
        this.addInputArgument(inputs);
        this.addIArgument(condition.condtionNum());
        this.addOutputArgument(Nd4j.create(inputs[0].length()), Nd4j.scalar(1.0));
    }

    public Choose(INDArray[] inputs, Condition condition) {
        this(inputs, Collections.emptyList(), Collections.emptyList(), condition);
    }

    public Choose(INDArray[] inputs, List<Integer> iArgs, List<Double> tArgs, Condition condition) {
        super(null, inputs, null);
        if (condition == null) {
            throw new ND4JIllegalArgumentException("Must specify a condition.");
        }
        if (!iArgs.isEmpty()) {
            this.addIArgument(Ints.toArray(iArgs));
        }
        if (!tArgs.isEmpty()) {
            this.addTArgument(Doubles.toArray(tArgs));
        }
        this.addIArgument(condition.condtionNum());
        this.addOutputArgument(Nd4j.create(inputs[0].shape(), inputs[0].ordering()), Nd4j.scalar(DataType.LONG, 1.0));
    }

    public Choose(String opName, SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(opName, sameDiff, args, inPlace);
    }

    public Choose() {
    }

    @Override
    public String opName() {
        return "choose";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

