/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.bool;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformBoolOp;

public class BooleanNot
extends BaseTransformBoolOp {
    public BooleanNot(SameDiff sameDiff, SDVariable i_v) {
        super(sameDiff, i_v, false);
    }

    public BooleanNot() {
    }

    public BooleanNot(@NonNull INDArray x) {
        this(x, x);
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
    }

    public BooleanNot(@NonNull INDArray x, INDArray z) {
        super(x, null, z);
        if (x == null) {
            throw new NullPointerException("x is marked @NonNull but is null");
        }
        Preconditions.checkArgument((x.dataType() == DataType.BOOL ? 1 : 0) != 0, (String)"X operand must be BOOL");
        Preconditions.checkArgument((z.dataType() == DataType.BOOL ? 1 : 0) != 0, (String)"Z operand must be BOOL");
    }

    @Override
    public int opNum() {
        return 7;
    }

    @Override
    public String onnxName() {
        return "not_applicable";
    }

    @Override
    public String tensorflowName() {
        return "not_applicable";
    }

    @Override
    public String opName() {
        return "bool_not";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.singletonList(this.f().zerosLike(this.arg()));
    }
}

