/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;

public class MaxOut
extends BaseTransformOp {
    private Number max = Double.NaN;

    public MaxOut(SameDiff sameDiff, SDVariable i_v, boolean inPlace, Number max) {
        super(sameDiff, i_v, inPlace);
        this.max = max;
    }

    public MaxOut(SameDiff sameDiff, SDVariable i_v, Object[] extraArgs, Number max) {
        super(sameDiff, i_v, extraArgs);
        this.max = max;
    }

    public MaxOut() {
    }

    public MaxOut(INDArray x, INDArray z) {
        super(x, z);
    }

    public MaxOut(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String opName() {
        return "maxout";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Maxout";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return null;
    }

    @Override
    public DataType resultType() {
        return Nd4j.defaultFloatingPointType();
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.TRANSFORM_STRICT;
    }

    @Override
    public boolean validateDataTypes(boolean experimentalMode) {
        if (!this.x().isR()) {
            return false;
        }
        if (this.y() != null && !this.y().isR()) {
            return false;
        }
        return this.z() == null || this.z().dataType() == this.x().dataType();
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        ArrayList<LongShapeDescriptor> ret = new ArrayList<LongShapeDescriptor>(1);
        if (this.arg() == null) {
            throw new ND4JIllegalStateException("No arg found for op!");
        }
        INDArray arr = this.sameDiff.getArrForVarName(this.arg().getVarName());
        if (arr == null) {
            return Collections.emptyList();
        }
        ret.add(LongShapeDescriptor.fromShape(arr.shape(), Nd4j.defaultFloatingPointType()));
        return ret;
    }
}

