/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Unstack
extends DynamicCustomOp {
    private int num = -1;
    private int jaxis;

    public Unstack() {
    }

    public Unstack(SameDiff sameDiff, SDVariable value, int axis) {
        super(null, sameDiff, new SDVariable[]{value}, false);
        this.jaxis = axis;
        if (value.getShape() != null && value.getShape()[axis] != -1L) {
            this.num = (int)value.getShape()[axis];
        }
        if (this.num <= 0) {
            throw new ND4JIllegalStateException("Unstack: Unable to infer number of outputs from input. Provide number of outputs explicitly.");
        }
        this.addArgs();
    }

    public Unstack(SameDiff sameDiff, SDVariable value, int axis, int num) {
        super(null, sameDiff, new SDVariable[]{value}, false);
        this.jaxis = axis;
        this.num = num;
        this.addArgs();
    }

    public Unstack(INDArray in, INDArray[] out, int axis) {
        super(null, new INDArray[]{in}, out, null, (int[])null);
        this.jaxis = axis;
        this.addArgs();
    }

    public void addArgs() {
        this.addIArgument(this.jaxis);
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Unstack", "Unpack"};
    }

    @Override
    public String tensorflowName() {
        return "Unstack";
    }

    @Override
    public String opName() {
        return "unstack";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        int axis;
        AttrValue attrAxis = nodeDef.getAttrOrThrow("axis");
        this.jaxis = axis = (int)attrAxis.getI();
        AttrValue attrNum = nodeDef.getAttrOrDefault("num", null);
        if (attrNum != null) {
            this.num = (int)attrNum.getI();
        }
        this.addArgs();
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping axisMapping = PropertyMapping.builder().onnxAttrName("axis").tfInputPosition(-1).propertyNames(new String[]{"axis"}).build();
        map.put("axis", axisMapping);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        throw new UnsupportedOperationException("No analog found for onnx for " + this.opName());
    }

    @Override
    public int getNumOutputs() {
        return this.num;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.singletonList(this.sameDiff.stack(this.jaxis, f1.toArray(new SDVariable[f1.size()])));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected list with exactly 1 datatype for %s, got %s", this.getClass(), dataTypes);
        ArrayList<DataType> out = new ArrayList<DataType>();
        for (int i = 0; i < this.num; ++i) {
            out.add(dataTypes.get(0));
        }
        return out;
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        if (this.inputArguments.size() == 1 && ((INDArray)this.inputArguments.get(0)).rank() == 1) {
            INDArray arr = (INDArray)this.inputArguments.get(0);
            Preconditions.checkState((this.jaxis == 0 ? 1 : 0) != 0, (String)"Can only unstack along dimension 0 for rank 1 arrays, got axis %s for array %ndShape", (Object)this.jaxis, (Object)arr);
            LongShapeDescriptor lsd = LongShapeDescriptor.fromShape(new long[0], arr.dataType());
            List<Object> out = Arrays.asList(ArrayUtil.nTimes((int)((int)arr.length()), (Object)lsd, LongShapeDescriptor.class));
            return out;
        }
        return super.calculateOutputShape();
    }
}

