/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceFloatOp;

public class LogSumExp
extends BaseReduceFloatOp {
    public LogSumExp(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public LogSumExp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public LogSumExp() {
    }

    public LogSumExp(INDArray x, int ... dimensions) {
        super(x, dimensions);
    }

    public LogSumExp(INDArray x, INDArray z, int ... dimensions) {
        super(x, z, dimensions);
    }

    @Override
    public int opNum() {
        return 11;
    }

    @Override
    public String opName() {
        return "logexpsum";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        SDVariable exp = this.f().exp(this.arg());
        SDVariable sumExp = exp.sum(this.dimensions);
        SDVariable gradProd = f1.get(0).div(sumExp);
        SDVariable dSumExpdx = this.f().sumBp(this.arg(), gradProd, this.keepDims, this.dimensions).mul(exp);
        return Collections.singletonList(dSumExpdx);
    }

    @Override
    public String onnxName() {
        return "ReduceLogSumExp";
    }

    @Override
    public String tensorflowName() {
        return "reduce_logsumexp";
    }
}

