/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class SoftmaxCrossEntropyWithLogitsLoss
extends DynamicCustomOp {
    protected int classesDim;

    public SoftmaxCrossEntropyWithLogitsLoss(SameDiff sameDiff, SDVariable logits, SDVariable weights, SDVariable labels, int classesDim) {
        super(null, sameDiff, new SDVariable[]{logits, weights, labels}, false);
        this.classesDim = classesDim;
        this.addIArgument(classesDim);
    }

    @Override
    public String opName() {
        return "softmax_cross_entropy_loss_with_logits";
    }

    @Override
    public String tensorflowName() {
        return "SoftmaxCrossEntropyWithLogits";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && (inputDataTypes.size() == 2 || inputDataTypes.size() == 3) ? 1 : 0) != 0, (String)"Expected 2 or 3 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable[] grads = this.f().lossSoftmaxCrossEntropyWithLogitsBp(this.arg(2), this.arg(0), this.arg(1), this.classesDim);
        return Arrays.asList(grads);
    }

    public SoftmaxCrossEntropyWithLogitsLoss() {
    }
}

